/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.PathEntry;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDescriptor {
    private static final Log LOG = LogFactory.getLog(ProjectDescriptor.class);
    private String id;
    private String name;
    private String comment;
    private File projectFolder;
    private List<Module> modules;
    private List<PathEntry> classpath;
    private ClassLoader classLoader;

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public void setProjectFolder(File projectRoot) {
        this.projectFolder = projectRoot;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public List<PathEntry> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<PathEntry> classpath) {
        this.classpath = classpath;
    }

    public Module getModuleByClassName(String className) {
        if (this.modules != null && className != null) {
            for (Module module : this.modules) {
                if (!className.equals(module.getClassname())) continue;
                return module;
            }
        }
        return null;
    }

    public ClassLoader getClassLoader(boolean reload) {
        if (this.classLoader == null || reload) {
            this.unregisterClassloader(this.classLoader);
            URL[] urls = this.getClassPathUrls();
            this.classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public URL[] getClassPathUrls() {
        if (this.classpath == null) {
            return new URL[0];
        }
        URL[] urls = new URL[this.classpath.size()];
        int i = 0;
        for (PathEntry entry : this.classpath) {
            File f = new File(entry.getPath());
            try {
                urls[i] = f.isAbsolute() ? f.toURL() : new File(this.projectFolder, entry.getPath()).toURL();
                ++i;
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("Bad URL in classpath \"" + entry.getPath() + "\""));
            }
        }
        return urls;
    }

    private void unregisterClassloader(ClassLoader classLoader) {
        if (classLoader != null) {
            JavaOpenClass.resetClassloader((ClassLoader)classLoader);
            LogFactory.release((ClassLoader)classLoader);
            String2DataConvertorFactory.unregisterClassLoader((ClassLoader)classLoader);
        }
    }

    protected void finalize() throws Throwable {
        this.unregisterClassloader(this.classLoader);
        super.finalize();
    }
}

