/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openl.main.OpenLProjectPropertiesLoader;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ModuleType;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.util.FileTool;
import org.openl.util.StringTool;
import org.openl.util.tree.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseBasedResolvingStrategy
implements ResolvingStrategy {
    private FileTreeIterator.FileTreeAdaptor treeAdaptor;

    public FileTreeIterator.FileTreeAdaptor getTreeAdaptor() {
        if (this.treeAdaptor == null) {
            this.treeAdaptor = new FileTreeIterator.FileTreeAdaptor();
        }
        return this.treeAdaptor;
    }

    public void setTreeAdaptor(FileTreeIterator.FileTreeAdaptor treeAdaptor) {
        this.treeAdaptor = treeAdaptor;
    }

    @Override
    public boolean isRulesProject(File folder) {
        try {
            if (!folder.exists() || !folder.isDirectory()) {
                return false;
            }
            if (!FileTool.containsFile((File)folder, (String)".project", (boolean)false)) {
                return false;
            }
            if (!FileTool.containsFileText((File)folder, (String)".project", (String)"openlbuilder")) {
                return false;
            }
            return this.listPotentialOpenLWrappersClassNames(folder).length != 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String[] listPotentialOpenLWrappersClassNames(File project) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String startDirs = System.getProperty("org.openl.rules.wrapper.dir", "gen");
        String wrapperSuffixes = System.getProperty("org.openl.rules.wrapper.suffixes", "Wrapper.java");
        String[] srcRoots = StringTool.tokenize((String)startDirs, (String)", ");
        String[] suffixes = StringTool.tokenize((String)wrapperSuffixes, (String)", ");
        for (String srcRoot : srcRoots) {
            this.listPotentialOpenLWrappersClassNames(project, srcRoot, suffixes, list);
        }
        return list.toArray(new String[list.size()]);
    }

    private String javaClassName(File f, String srcroot) {
        String path = f.getPath();
        int inc = 1;
        if (srcroot.endsWith(File.separator)) {
            inc = 0;
        }
        String jpath = path.substring(srcroot.length() + inc, path.length() - 5);
        return jpath.replace(File.separatorChar, '.');
    }

    public void listPotentialOpenLWrappersClassNames(File project, String srcRoot, String[] suffixes, List<String> list) throws IOException {
        File searchDir = new File(project.getCanonicalPath(), srcRoot);
        FileTreeIterator fti = new FileTreeIterator(searchDir, this.getTreeAdaptor(), 0);
        while (fti.hasNext()) {
            File f = (File)fti.next();
            for (String suffix : suffixes) {
                if (!f.getName().endsWith(suffix)) continue;
                list.add(this.javaClassName(f, searchDir.getCanonicalPath()));
            }
        }
    }

    @Override
    public ProjectDescriptor resolveProject(File folder) {
        String[] wrapperClassNames;
        ProjectDescriptor descriptor = new ProjectDescriptor();
        descriptor.setId(folder.getName());
        descriptor.setName(folder.getName());
        descriptor.setProjectFolder(folder);
        try {
            wrapperClassNames = this.listPotentialOpenLWrappersClassNames(folder);
        }
        catch (IOException e) {
            wrapperClassNames = new String[]{};
        }
        ArrayList<Module> projectModules = new ArrayList<Module>();
        for (String className : wrapperClassNames) {
            projectModules.add(this.createModule(descriptor, className));
        }
        descriptor.setModules(projectModules);
        descriptor.setClasspath(this.getClassPath(folder.getAbsolutePath()));
        return descriptor;
    }

    private Module createModule(ProjectDescriptor project, String className) {
        Module module = new Module();
        module.setProject(project);
        module.setClassname(className);
        module.setName(this.getModuleName(project.getProjectFolder(), className));
        module.setType(ModuleType.STATIC);
        return module;
    }

    public String getModuleName(File projectFolder, String wrapperClassName) {
        OpenLProjectPropertiesLoader propertiesLoader = new OpenLProjectPropertiesLoader();
        Properties p = propertiesLoader.loadProjectProperties(projectFolder.getAbsolutePath());
        if (p == null || !p.containsKey(wrapperClassName + ".display.name")) {
            return wrapperClassName;
        }
        return p.getProperty(wrapperClassName + ".display.name", wrapperClassName);
    }

    private List<PathEntry> getClassPath(String projectFolder) {
        OpenLProjectPropertiesLoader propertiesLoader = new OpenLProjectPropertiesLoader();
        String usedClassPath = propertiesLoader.loadExistingClasspath(projectFolder);
        String usedClasspathSeparator = propertiesLoader.loadExistingClasspathSeparator(projectFolder);
        String classPath = usedClasspathSeparator != null ? usedClassPath.replace(usedClasspathSeparator, File.pathSeparator) : usedClassPath;
        String[] files = StringTool.tokenize((String)classPath, (String)File.pathSeparator);
        ArrayList<PathEntry> pathEntries = new ArrayList<PathEntry>(files.length);
        for (int i = 0; i < files.length; ++i) {
            pathEntries.add(new PathEntry(files[i]));
        }
        return pathEntries;
    }
}

