/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.util.ASelector;
import org.openl.util.ISelector;
import org.openl.util.Log;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesProjectResolver {
    private List<ResolvingStrategy> resolvingStrategies;
    private String workspace;
    private ISelector<String> projectSelector;

    public static RulesProjectResolver loadProjectResolverFromClassPath() {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("project-resolver-beans.xml");
        return (RulesProjectResolver)applicationContext.getBean("projectResolver");
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public List<ResolvingStrategy> getResolvingStrategies() {
        return this.resolvingStrategies;
    }

    public void setResolvingStrategies(List<ResolvingStrategy> resolvingStrategies) {
        this.resolvingStrategies = resolvingStrategies;
    }

    public void setProjectSelector(ISelector<String> projectSelector) {
        this.projectSelector = projectSelector;
    }

    public List<ProjectDescriptor> listOpenLProjects() {
        ArrayList<ProjectDescriptor> projects = new ArrayList<ProjectDescriptor>();
        File[] f = this.listProjects();
        for (int i = 0; i < f.length; ++i) {
            try {
                ResolvingStrategy strategy;
                if (!this.getProjectSelector().select((Object)f[i].getName()) || (strategy = this.isRulesProject(f[i])) == null) continue;
                projects.add(strategy.resolveProject(f[i]));
                continue;
            }
            catch (Exception e) {
                Log.warn((Object)String.format("Failed to resolve project in [%s]", f[i].getAbsoluteFile()), (Throwable)e);
            }
        }
        return projects;
    }

    public ResolvingStrategy isRulesProject(File folder) {
        for (ResolvingStrategy strategy : this.resolvingStrategies) {
            if (!strategy.isRulesProject(folder)) continue;
            return strategy;
        }
        return null;
    }

    public synchronized ISelector<String> getProjectSelector() {
        if (this.projectSelector == null) {
            this.projectSelector = this.getDefaultProjectSelector();
        }
        return this.projectSelector;
    }

    private ISelector<String> getDefaultProjectSelector() {
        String startProject = System.getProperty("org.openl.rules.start.project");
        return startProject == null ? ASelector.selectAll((Object)"") : ASelector.selectObject((Object)startProject);
    }

    private File[] listProjects() {
        File wsfolder = new File(this.workspace);
        return wsfolder.listFiles();
    }

    public List<File> listOpenLFolders() {
        ArrayList<File> res = new ArrayList<File>();
        for (File f : this.listProjects()) {
            if (this.isRulesProject(f) == null) continue;
            res.add(f);
        }
        return res;
    }
}

