/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.resolving;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ModuleType;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.resolving.ResolvingStrategy;
import org.openl.util.FileTypeHelper;

public class SimpleXlsResolvingStrategy
implements ResolvingStrategy {
    public boolean isRulesProject(File folder) {
        if (!folder.isDirectory()) {
            return false;
        }
        for (File f : folder.listFiles()) {
            if (!FileTypeHelper.isExcelFile((String)f.getName())) continue;
            return true;
        }
        return false;
    }

    public ProjectDescriptor resolveProject(File folder) {
        ProjectDescriptor project = this.createDescriptor(folder);
        ArrayList<Module> modules = new ArrayList<Module>();
        for (File f : folder.listFiles()) {
            if (!FileTypeHelper.isExcelFile((String)f.getName())) continue;
            modules.add(this.createModule(project, f));
        }
        project.setModules(modules);
        return project;
    }

    private Module createModule(ProjectDescriptor project, File xlsFile) {
        Module module = new Module();
        module.setProject(project);
        module.setRulesRootPath(new PathEntry(xlsFile.getAbsolutePath()));
        module.setType(ModuleType.API);
        module.setClassname(FilenameUtils.removeExtension((String)xlsFile.getName()));
        module.setName(FilenameUtils.removeExtension((String)xlsFile.getName()));
        return module;
    }

    private ProjectDescriptor createDescriptor(File folder) {
        ProjectDescriptor project = new ProjectDescriptor();
        project.setProjectFolder(folder);
        project.setName(folder.getName());
        project.setId(folder.getName());
        return project;
    }
}

