/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.project.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import java.util.ArrayList;
import org.openl.rules.project.IProjectDescriptorSerializer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.PathEntry;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.project.xml.ModuleTypeConverter;

public class XmlProjectDescriptorSerializer
implements IProjectDescriptorSerializer {
    private static final String PROJECT_DESCRIPTOR_TAG = "project";
    private static final String MODULE_TAG = "module";
    private static final String PATH_TAG = "entry";
    private XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());

    public XmlProjectDescriptorSerializer() {
        this.xstream.setMode(1001);
        this.xstream.aliasType(PROJECT_DESCRIPTOR_TAG, ProjectDescriptor.class);
        this.xstream.aliasType(MODULE_TAG, Module.class);
        this.xstream.aliasType(PATH_TAG, PathEntry.class);
        this.xstream.useAttributeFor(PathEntry.class, "path");
        this.xstream.aliasField("rules-root", Module.class, "rulesRootPath");
        this.xstream.registerConverter((SingleValueConverter)new ModuleTypeConverter());
    }

    public String serialize(ProjectDescriptor source) {
        return this.xstream.toXML((Object)source);
    }

    public ProjectDescriptor deserialize(InputStream source) {
        ProjectDescriptor descriptor = (ProjectDescriptor)this.xstream.fromXML(source);
        this.postProcess(descriptor);
        return descriptor;
    }

    private void postProcess(ProjectDescriptor descriptor) {
        if (descriptor.getClasspath() == null) {
            descriptor.setClasspath(new ArrayList<PathEntry>());
        }
        if (descriptor.getModules() == null) {
            descriptor.setModules(new ArrayList<Module>());
        }
    }
}

