/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ruleservice.publish;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.openl.rules.project.instantiation.ReloadType;
import org.openl.rules.project.instantiation.RulesInstantiationStrategy;
import org.openl.rules.project.instantiation.RulesInstantiationStrategyFactory;
import org.openl.rules.project.instantiation.RulesServiceEnhancer;
import org.openl.rules.project.model.Module;
import org.openl.rules.project.model.ProjectDescriptor;
import org.openl.rules.ruleservice.publish.DeploymentAdmin;
import org.springframework.beans.factory.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServicesDeployAdmin
implements DeploymentAdmin {
    private static final Log LOG = LogFactory.getLog(WebServicesDeployAdmin.class);
    private ObjectFactory serverFactory;
    private Map<String, Collection<Server>> runningServices = new HashMap<String, Collection<Server>>();
    private String baseAddress;
    private RulesServiceEnhancer serviceEnhancer;
    private boolean provideRuntimeContext;

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String address) {
        this.baseAddress = address;
    }

    public ObjectFactory getServerFactory() {
        return this.serverFactory;
    }

    public void setServerFactory(ObjectFactory serverFactory) {
        this.serverFactory = serverFactory;
    }

    public boolean isProvideRuntimeContext() {
        return this.provideRuntimeContext;
    }

    public void setProvideRuntimeContext(boolean provideRuntimeContext) {
        this.provideRuntimeContext = provideRuntimeContext;
    }

    public synchronized void deploy(String serviceName, List<ProjectDescriptor> infoList) {
        this.undeploy(serviceName);
        String address = this.getBaseAddress() + serviceName + "/";
        ArrayList<Server> servers = new ArrayList<Server>();
        for (ProjectDescriptor wsInfo : infoList) {
            for (Module rulesModule : wsInfo.getModules()) {
                try {
                    servers.add(this.deploy(address, rulesModule));
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to create service", t);
                }
            }
        }
        this.runningServices.put(serviceName, servers);
    }

    private Server deploy(String baseAddress, Module rulesModule) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ServerFactoryBean svrFactory = this.getServerFactoryBean();
        this.instantiateServiceBean(rulesModule, svrFactory);
        return this.exposeWebService(baseAddress, rulesModule, svrFactory);
    }

    public synchronized void undeploy(String serviceName) {
        Collection<Server> servers = this.runningServices.remove(serviceName);
        if (servers != null) {
            for (Server server : servers) {
                server.stop();
            }
        }
    }

    ServerFactoryBean getServerFactoryBean() {
        if (this.serverFactory != null) {
            return (ServerFactoryBean)this.serverFactory.getObject();
        }
        return new ServerFactoryBean();
    }

    private void instantiateServiceBean(Module rulesModule, ServerFactoryBean svrFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        RulesInstantiationStrategy strategy = RulesInstantiationStrategyFactory.getStrategy((Module)rulesModule, (boolean)true);
        if (this.isProvideRuntimeContext()) {
            this.serviceEnhancer = new RulesServiceEnhancer(strategy);
            svrFactory.setServiceClass(this.serviceEnhancer.getServiceClass());
            svrFactory.setServiceBean(this.serviceEnhancer.instantiate(ReloadType.SINGLE));
        } else {
            svrFactory.setServiceClass(strategy.getServiceClass());
            svrFactory.setServiceBean(strategy.instantiate(ReloadType.SINGLE));
        }
    }

    protected String getServiceNameForModule(Module rulesModule) {
        int postfixIndex = rulesModule.getClassname().lastIndexOf("Wrapper");
        if (postfixIndex > 0) {
            return rulesModule.getClassname().substring(0, postfixIndex);
        }
        return rulesModule.getClassname();
    }

    private Server exposeWebService(String baseAddress, Module rulesModule, ServerFactoryBean svrFactory) {
        svrFactory.setAddress(baseAddress + this.getServiceNameForModule(rulesModule));
        return svrFactory.create();
    }
}

