/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.domain.IDomain;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.util.Log;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRowHelper {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    public static final String CONSTRUCTOR = "constructor";

    public static int calculateHeight(ILogicalTable table) {
        int height = table.getHeight();
        int last = -1;
        for (int i = 0; i < height; ++i) {
            String source = ((ILogicalTable)table.getRow(i)).getSource().getCell(0, 0).getStringValue();
            if (source == null || source.trim().length() == 0) continue;
            last = i;
        }
        return last + 1;
    }

    public static String[] extractElementsFromCommaSeparatedArray(ILogicalTable cell) {
        String[] tokens = null;
        String src = cell.getSource().getCell(0, 0).getStringValue();
        if (src != null) {
            tokens = StringTool.splitAndEscape((String)src, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        }
        return tokens;
    }

    public static Object loadCommaSeparatedParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor) throws SyntaxNodeException {
        Object arrayValues = null;
        String[] tokens = null;
        tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(cell);
        if (tokens != null) {
            ArrayList<Object> values = new ArrayList<Object>(tokens.length);
            for (String token : tokens) {
                Object res = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor, token, null, true);
                if (res == null) {
                    res = paramType.nullObject();
                    RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, true);
                }
                values.add(res);
            }
            int valuesArraySize = values.size();
            arrayValues = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{valuesArraySize});
            for (int i = 0; i < valuesArraySize; ++i) {
                Array.set(arrayValues, i, values.get(i));
            }
        }
        return arrayValues;
    }

    public static IOpenClass getType(String typeCode, IBindingContext bindingContext) {
        if (typeCode.endsWith("[]")) {
            String baseCode = typeCode.substring(0, typeCode.length() - 2);
            IOpenClass baseType = bindingContext.findType("org.openl.this", baseCode);
            if (baseType == null) {
                return null;
            }
            return baseType.getAggregateInfo().getIndexedAggregateType(baseType, 1);
        }
        IOpenClass type = bindingContext.findType("org.openl.this", typeCode);
        return type;
    }

    public static void loadParams(Object[] array, int from, Object[] paramValues, Object target, Object[] params, IRuntimeEnv env) {
        for (int i = 0; i < paramValues.length; ++i) {
            Object value = paramValues[i];
            if (value instanceof IOpenMethod) {
                value = ((IOpenMethod)value).invoke(target, params, env);
            } else if (value instanceof ArrayHolder) {
                value = ((ArrayHolder)value).invoke(target, params, env);
            }
            array[i + from] = value;
        }
    }

    public static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter) throws SyntaxNodeException {
        Object res;
        ICell theCell = table.getSource().getCell(0, 0);
        if (theCell.hasNativeType() && theCell.getNativeType() == 0 && (res = RuleRowHelper.loadNativeValue(theCell, paramType, openlAdapter.getBindingContext(), paramName, ruleName, table)) != null) {
            try {
                RuleRowHelper.validateValue(res, paramType);
            }
            catch (Throwable t) {
                throw SyntaxNodeExceptionUtils.createError(null, (Throwable)t, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(table.getSource(), openlAdapter.getBindingContext()));
            }
            RuleRowHelper.setCellMetaInfo(table, paramName, paramType, false);
            return res;
        }
        String src = theCell.getStringValue();
        return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src, null, false);
    }

    private static Object loadNativeValue(ICell cell, IOpenClass paramType, IBindingContext bindingContext, String paramName, String ruleName, ILogicalTable table) {
        Class expectedType = paramType.getInstanceClass();
        double value = cell.getNativeNumber();
        IObjectToDataConvertor objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.class);
        Object res = null;
        if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
            res = objectConvertor.convert(value, bindingContext);
        } else {
            objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Date.class);
            if (objectConvertor != ObjectToDataConvertorFactory.NO_Convertor) {
                Date dateValue = cell.getNativeDate();
                res = objectConvertor.convert(dateValue, bindingContext);
            } else if ((double)((int)value) == value && (objectConvertor = ObjectToDataConvertorFactory.getConvertor(expectedType, Integer.class)) != ObjectToDataConvertorFactory.NO_Convertor) {
                res = objectConvertor.convert((int)value, bindingContext);
            }
        }
        if (res != null && res instanceof IMetaHolder) {
            RuleRowHelper.setMetaInfo((IMetaHolder)res, table, paramName, ruleName, bindingContext);
        }
        return res;
    }

    public static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdapter, String source, Object value, boolean isPartOfArray) throws SyntaxNodeException {
        if (source != null && (source = source.trim()).length() != 0) {
            Object result;
            if (openlAdapter != null && openlAdapter.getHeader() != null) {
                IOpenMethodHeader old_header = openlAdapter.getHeader();
                OpenMethodHeader newHeader = new OpenMethodHeader(old_header.getName(), paramType, old_header.getSignature(), old_header.getDeclaringClass());
                openlAdapter.setHeader((IOpenMethodHeader)newHeader);
                if (source.startsWith("{") && source.endsWith("}")) {
                    GridCellSourceCodeModule srcCode = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                    return openlAdapter.makeMethod(srcCode);
                }
                if (source.startsWith("=") && (source.length() > 2 || source.length() == 2 && Character.isLetterOrDigit(source.charAt(1)))) {
                    GridCellSourceCodeModule gridSource = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                    SubTextSourceCodeModule code = new SubTextSourceCodeModule((IOpenSourceCodeModule)gridSource, 1);
                    return openlAdapter.makeMethod((IOpenSourceCodeModule)code);
                }
            }
            Class expectedType = paramType.getInstanceClass();
            RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, isPartOfArray);
            try {
                result = RuleRowHelper.parseStringValue(source, expectedType, openlAdapter.getBindingContext());
            }
            catch (Exception e) {
                String message = String.format("Cannot parse cell value '%s'", source);
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            if (result instanceof IMetaHolder) {
                RuleRowHelper.setMetaInfo((IMetaHolder)result, cell, paramName, ruleName, openlAdapter.getBindingContext());
            }
            try {
                RuleRowHelper.validateValue(result, paramType);
            }
            catch (Exception e) {
                String message = String.format("Invalid cell value '%s'", source);
                GridCellSourceCodeModule cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), openlAdapter.getBindingContext());
                throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)cellSourceCodeModule);
            }
            return result;
        }
        RuleRowHelper.setCellMetaInfo(cell, paramName, paramType, false);
        return null;
    }

    private static Object parseStringValue(String source, Class<?> expectedType, IBindingContext bindingContext) {
        IString2DataConvertor convertor = String2DataConvertorFactory.getConvertor(expectedType);
        return convertor.parse(source, null, bindingContext);
    }

    public static boolean isCommaSeparatedArray(ILogicalTable valuesTable) {
        String stringValue = valuesTable.getSource().getCell(0, 0).getStringValue();
        if (stringValue != null) {
            return stringValue.contains(ARRAY_ELEMENTS_SEPARATOR);
        }
        return false;
    }

    public static boolean isFormula(ILogicalTable valuesTable) {
        String stringValue = valuesTable.getSource().getCell(0, 0).getStringValue();
        if (stringValue != null) {
            stringValue.trim();
            return stringValue.startsWith("=");
        }
        return false;
    }

    public static void setCellMetaInfo(ILogicalTable cell, String paramName, IOpenClass paramType, boolean isMultiValue) {
        CellMetaInfo meta = new CellMetaInfo(CellMetaInfo.Type.DT_DATA_CELL, paramName, paramType, isMultiValue);
        IWritableGrid.Tool.putCellMetaInfo(cell.getSource(), 0, 0, meta);
    }

    private static void setMetaInfo(IMetaHolder holder, ILogicalTable cell, String paramName, String ruleName, IBindingContext bindingContext) {
        if (!bindingContext.isExecutionMode()) {
            ValueMetaInfo valueMetaInfo = new ValueMetaInfo();
            valueMetaInfo.setShortName(paramName);
            valueMetaInfo.setFullName(ruleName == null ? paramName : ruleName + "." + paramName);
            valueMetaInfo.setSource((IOpenSourceCodeModule)new GridCellSourceCodeModule(cell.getSource(), bindingContext));
            holder.setMetaInfo((IMetaInfo)valueMetaInfo);
        }
    }

    private static void validateValue(Object value, IOpenClass paramType) throws Exception {
        IDomain domain = paramType.getDomain();
        if (domain == null || domain.selectObject(value)) {
            return;
        }
        String message = String.format("The value '%s' is outside of domain %s", value, domain.toString());
        throw new Exception(message);
    }

    public static Object loadParam(ILogicalTable dataTable, IOpenClass paramType, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, boolean indexed) throws SyntaxNodeException {
        if (!indexed) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        int height = RuleRowHelper.calculateHeight(dataTable = LogicalTableHelper.make1ColumnTable(dataTable));
        if (height == 0) {
            return null;
        }
        if (height == 1 && !RuleRowHelper.isCommaSeparatedArray(dataTable) && !paramType.isArray()) {
            try {
                return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
            }
            catch (Exception e) {
                Log.debug((Object)e);
            }
        }
        return RuleRowHelper.loadArrayParameters(dataTable, paramName, ruleName, openlAdaptor, paramType);
    }

    private static Object loadArrayParameters(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass arrayType) throws SyntaxNodeException {
        int height = RuleRowHelper.calculateHeight(dataTable);
        IOpenClass paramType = arrayType.getAggregateInfo().getComponentType(arrayType);
        if (height == 1 && RuleRowHelper.isCommaSeparatedArray(dataTable)) {
            return RuleRowHelper.loadCommaSeparatedArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType);
        }
        if (height == 1 && RuleRowHelper.isFormula(dataTable)) {
            return RuleRowHelper.loadSingleParam(arrayType, paramName, ruleName, dataTable, openlAdaptor);
        }
        return RuleRowHelper.loadSimpleArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType);
    }

    private static Object loadCommaSeparatedArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        ILogicalTable paramSource = (ILogicalTable)dataTable.getRow(0);
        Object params = RuleRowHelper.loadCommaSeparatedParam(paramType, paramName, ruleName, paramSource, openlAdaptor);
        Class<?> paramClass = params.getClass();
        if (paramClass.isArray() && !paramClass.getComponentType().isPrimitive()) {
            return RuleRowHelper.processAsObjectParams(paramType, (Object[])params);
        }
        return params;
    }

    private static Object processAsObjectParams(IOpenClass paramType, Object[] paramsArray) {
        ArrayList<CompositeMethod> methodsList = null;
        Object ary = null;
        int paramsLength = paramsArray.length;
        ary = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{paramsLength});
        for (int i = 0; i < paramsLength; ++i) {
            if (paramsArray[i] instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod((List<CompositeMethod>)methodsList, (CompositeMethod)paramsArray[i]));
                continue;
            }
            Array.set(ary, i, paramsArray[i]);
        }
        return methodsList == null ? ary : new ArrayHolder(ary, methodsList.toArray(new CompositeMethod[methodsList.size()]));
    }

    private static List<CompositeMethod> addMethod(List<CompositeMethod> methods, CompositeMethod method) {
        if (methods == null) {
            methods = new ArrayList<CompositeMethod>();
        }
        methods.add(method);
        return methods;
    }

    private static Object loadSimpleArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass paramType) throws SyntaxNodeException {
        int height = RuleRowHelper.calculateHeight(dataTable);
        ArrayList<CompositeMethod> methodsList = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < height; ++i) {
            ILogicalTable cell = (ILogicalTable)dataTable.getRow(i);
            Object parameter = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor);
            if (parameter instanceof CompositeMethod) {
                methodsList = new ArrayList<CompositeMethod>(RuleRowHelper.addMethod(methodsList, (CompositeMethod)parameter));
                continue;
            }
            if (parameter == null) continue;
            values.add(parameter);
        }
        Object ary = paramType.getAggregateInfo().makeIndexedAggregate(paramType, new int[]{values.size()});
        for (int i = 0; i < values.size(); ++i) {
            Array.set(ary, i, values.get(i));
        }
        return methodsList == null ? ary : new ArrayHolder(ary, methodsList.toArray(new CompositeMethod[methodsList.size()]));
    }
}

