/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.rules.annotations.Executable;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetInvoker;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.types.impl.AMethod;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Executable
public class Spreadsheet
extends AMethod
implements IMemberMetaInfo {
    private SpreadsheetBoundNode node;
    protected IResultBuilder resultBuilder;
    private SpreadsheetCell[][] cells;
    private String[] rowNames;
    private String[] columnNames;
    private SpreadsheetOpenClass spreadsheetType;
    private Map<String, Object> properties;
    private Invokable invoker;

    public Spreadsheet(IOpenMethodHeader header, SpreadsheetBoundNode boundNode) {
        super(header);
        this.node = boundNode;
        this.properties = ((TableSyntaxNode)this.node.getSyntaxNode()).getTableProperties().getAllProperties();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setBoundNode(SpreadsheetBoundNode node) {
        this.node = node;
    }

    public SpreadsheetBoundNode getBoundNode() {
        return this.node;
    }

    public SpreadsheetCell[][] getCells() {
        return this.cells;
    }

    public BindingDependencies getDependencies() {
        return null;
    }

    public IMemberMetaInfo getInfo() {
        return this;
    }

    public IResultBuilder getResultBuilder() {
        return this.resultBuilder;
    }

    public String getSourceUrl() {
        return ((TableSyntaxNode)this.node.getSyntaxNode()).getUri();
    }

    public SpreadsheetOpenClass getSpreadsheetType() {
        return this.spreadsheetType;
    }

    public TableSyntaxNode getSyntaxNode() {
        return this.node.getTableSyntaxNode();
    }

    public int getHeight() {
        return this.cells.length;
    }

    public void setCells(SpreadsheetCell[][] cells) {
        this.cells = cells;
    }

    public void setColumnNames(String[] colNames) {
        this.columnNames = colNames;
    }

    public void setResultBuilder(IResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    public void setSpreadsheetType(SpreadsheetOpenClass spreadsheetType) {
        this.spreadsheetType = spreadsheetType;
    }

    public int getWidth() {
        return this.cells[0].length;
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.invoker == null) {
            this.invoker = new SpreadsheetInvoker(this);
        }
        return this.invoker.invoke(target, params, env);
    }

    public List<SpreadsheetCell> listNonEmptyCells(SpreadsheetHeaderDefinition definition) {
        ArrayList<SpreadsheetCell> list = new ArrayList<SpreadsheetCell>();
        int row = definition.getRow();
        int col = definition.getColumn();
        if (row >= 0) {
            for (int i = 0; i < this.getWidth(); ++i) {
                if (this.cells[row][i].isEmpty()) continue;
                list.add(this.cells[row][i]);
            }
        } else {
            for (int i = 0; i < this.getHeight(); ++i) {
                if (this.cells[i][col].isEmpty()) continue;
                list.add(this.cells[i][col]);
            }
        }
        return list;
    }

    @Deprecated
    public int height() {
        return this.getHeight();
    }

    @Deprecated
    public int width() {
        return this.getWidth();
    }
}

