/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.meta.DoubleValue;
import org.openl.meta.IMetaInfo;
import org.openl.meta.StringValue;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.CellLoader;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.result.ArrayResultBuilder;
import org.openl.rules.calc.result.DefaultResultBuilder;
import org.openl.rules.calc.result.ScalarResultBuilder;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.convertor.String2DoubleConvertor;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.ConstOpenField;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

public class SpreadsheetBuilder {
    private static final String RETURN_NAME = "RETURN";
    private Spreadsheet spreadsheet;
    private SpreadsheetHeaderDefinition returnHeaderDefinition;
    private IBindingContext bindingContext;
    private TableSyntaxNode tableSyntaxNode;
    private ILogicalTable rowNamesTable;
    private ILogicalTable columnNamesTable;
    private Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = new HashMap<Integer, SpreadsheetHeaderDefinition>();
    private Map<String, SpreadsheetHeaderDefinition> varDefinitions = new HashMap<String, SpreadsheetHeaderDefinition>();
    private Map<Integer, IBindingContext> rowContexts = new HashMap<Integer, IBindingContext>();
    private Map<Integer, IBindingContextDelegator> colContexts = new HashMap<Integer, IBindingContextDelegator>();
    private List<SpreadsheetCell> formulaCells = new ArrayList<SpreadsheetCell>();

    public SpreadsheetBuilder(IBindingContext bindingContext, Spreadsheet spreadsheet, TableSyntaxNode tableSyntaxNode) {
        this.bindingContext = bindingContext;
        this.spreadsheet = spreadsheet;
        this.tableSyntaxNode = tableSyntaxNode;
    }

    public void build(ILogicalTable tableBody) {
        this.buildColumnRowNames(tableBody);
        this.buildHeaderTypes();
        try {
            this.processReturnCells();
            this.buildCells();
            this.buildReturn();
        }
        catch (SyntaxNodeException e) {
            this.tableSyntaxNode.addError(e);
            BindHelper.processError((SyntaxNodeException)e, (IBindingContext)this.bindingContext);
        }
    }

    private void addColumnHeader(int column, StringValue value) {
        SpreadsheetHeaderDefinition header = this.columnHeaders.get(column);
        if (header == null) {
            header = new SpreadsheetHeaderDefinition(-1, column);
            this.columnHeaders.put(column, header);
        }
        this.parseHeader(header, value);
    }

    private void addRowHeader(int row, StringValue value) {
        SpreadsheetHeaderDefinition header = this.rowHeaders.get(row);
        if (header == null) {
            header = new SpreadsheetHeaderDefinition(row, -1);
            this.rowHeaders.put(row, header);
        }
        this.parseHeader(header, value);
    }

    private void addColumnNames(int column, ILogicalTable logicalColumn) {
        for (int i = 0; i < logicalColumn.getHeight(); ++i) {
            IGridTable nameCell = ((ILogicalTable)logicalColumn.getRow(i)).getSource();
            String value = nameCell.getCell(0, 0).getStringValue();
            if (value != null) {
                String shortName = "scol" + column + "_" + i;
                StringValue stringValue = new StringValue(value, shortName, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(nameCell, this.bindingContext));
                this.addColumnHeader(column, stringValue);
            }
            this.spreadsheet.getColumnNames()[column] = value;
        }
    }

    private void addRowNames(int row, ILogicalTable logicalRow) {
        for (int i = 0; i < logicalRow.getWidth(); ++i) {
            IGridTable nameCell = ((ILogicalTable)logicalRow.getColumn(i)).getSource();
            String value = nameCell.getCell(0, 0).getStringValue();
            if (value != null) {
                String shortName = "srow" + row + "_" + i;
                StringValue sv = new StringValue(value, shortName, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(nameCell, this.bindingContext));
                this.addRowHeader(row, sv);
            }
            this.spreadsheet.getRowNames()[row] = value;
        }
    }

    private void buildCells() {
        int rowIndex;
        int rowsCount = this.rowNamesTable.getHeight();
        int columnsCount = this.columnNamesTable.getWidth();
        SpreadsheetOpenClass spreadsheetOpenClass = this.spreadsheet.getSpreadsheetType();
        ModuleBindingContext bindingContext = new ModuleBindingContext(this.bindingContext, (ModuleOpenClass)spreadsheetOpenClass);
        SpreadsheetCell[][] cells = new SpreadsheetCell[rowsCount][columnsCount];
        this.spreadsheet.setCells(cells);
        for (rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.rowNamesTable.getRow(rowIndex), (ILogicalTable)this.columnNamesTable.getColumn(columnIndex));
                ICell sourceCell = cell.getSource().getCell(0, 0);
                SpreadsheetCell spreadsheetCell = bindingContext.isExecutionMode() ? new SpreadsheetCell(rowIndex, columnIndex, null) : new SpreadsheetCell(rowIndex, columnIndex, sourceCell);
                cells[rowIndex][columnIndex] = spreadsheetCell;
                String code = sourceCell.getStringValue();
                IOpenClass type = this.deriveCellType(spreadsheetCell, cell, this.columnHeaders.get(columnIndex), this.rowHeaders.get(rowIndex), code);
                spreadsheetCell.setType(type);
                if (this.columnHeaders.get(columnIndex) == null || this.rowHeaders.get(rowIndex) == null) continue;
                for (SymbolicTypeDefinition columnDefinition : this.columnHeaders.get(columnIndex).getVars()) {
                    for (SymbolicTypeDefinition rowDefinition : this.rowHeaders.get(rowIndex).getVars()) {
                        String columnName = columnDefinition.getName().getIdentifier();
                        String rowName = rowDefinition.getName().getIdentifier();
                        String fieldname = "$" + columnName + "$" + rowName;
                        SpreadsheetCellField field = new SpreadsheetCellField((IOpenClass)spreadsheetOpenClass, fieldname, spreadsheetCell);
                        spreadsheetOpenClass.addField((IOpenField)field);
                    }
                }
            }
        }
        for (rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            IBindingContext rowBindingContext = this.getRowContext(rowIndex, (IBindingContext)bindingContext);
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                if (this.columnHeaders.get(columnIndex) == null || this.rowHeaders.get(rowIndex) == null) continue;
                IBindingContext columnBindingContext = this.getColumnContext(columnIndex, rowBindingContext);
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.rowNamesTable.getRow(rowIndex), (ILogicalTable)this.columnNamesTable.getColumn(columnIndex));
                SpreadsheetCell spreadsheetCell = cells[rowIndex][columnIndex];
                GridCellSourceCodeModule source = new GridCellSourceCodeModule(cell.getSource(), (IBindingContext)bindingContext);
                String code = source.getCode();
                if (CellLoader.isFormula(code)) {
                    this.formulaCells.add(spreadsheetCell);
                }
                String name = "$" + this.columnHeaders.get(columnIndex).getFirstname() + '$' + this.rowHeaders.get(rowIndex).getFirstname();
                ValueMetaInfo meta = new ValueMetaInfo(name, null, (IOpenSourceCodeModule)source);
                IOpenMethodHeader header = this.makeHeader(meta.getDisplayName(0), this.spreadsheet.getHeader(), spreadsheetCell.getType());
                IString2DataConvertor convertor = this.makeConvertor(spreadsheetCell.getType());
                CellLoader loader = new CellLoader(columnBindingContext, header, convertor);
                try {
                    Object cellValue = loader.loadSingleParam(source, (IMetaInfo)meta);
                    spreadsheetCell.setValue(cellValue);
                    continue;
                }
                catch (SyntaxNodeException e) {
                    this.tableSyntaxNode.addError(e);
                    BindHelper.processError((SyntaxNodeException)e, (IBindingContext)bindingContext);
                }
            }
        }
    }

    private void buildHeaderTypes() {
        SpreadsheetOpenClass spreadsheetType = new SpreadsheetOpenClass(null, this.spreadsheet.getName() + "Type", this.bindingContext.getOpenL());
        this.spreadsheet.setSpreadsheetType(spreadsheetType);
        for (SpreadsheetHeaderDefinition headerDefinition : this.varDefinitions.values()) {
            IOpenClass headerType = null;
            for (SymbolicTypeDefinition symbolicTypeDefinition : headerDefinition.getVars()) {
                if (symbolicTypeDefinition.getType() == null) continue;
                SyntaxNodeException error = null;
                IOpenClass type = this.bindingContext.findType("org.openl.this", symbolicTypeDefinition.getType().getIdentifier());
                if (type == null) {
                    String message = "Type not found: " + symbolicTypeDefinition.getType().getIdentifier();
                    error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)symbolicTypeDefinition.getType());
                } else if (headerType == null) {
                    headerType = type;
                } else if (headerType != type) {
                    error = SyntaxNodeExceptionUtils.createError((String)"Type redefinition", (ISyntaxNode)symbolicTypeDefinition.getType());
                }
                if (error == null) continue;
                this.tableSyntaxNode.addError(error);
                BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.bindingContext);
            }
            if (headerType == null) continue;
            headerDefinition.setType(headerType);
        }
    }

    protected void buildColumnRowNames(ILogicalTable tableBody) {
        this.rowNamesTable = (ILogicalTable)((ILogicalTable)tableBody.getColumn(0)).getRows(1);
        this.columnNamesTable = (ILogicalTable)((ILogicalTable)tableBody.getRow(0)).getColumns(1);
        int height = this.rowNamesTable.getHeight();
        int width = this.columnNamesTable.getWidth();
        this.spreadsheet.setRowNames(new String[height]);
        this.spreadsheet.setColumnNames(new String[width]);
        for (int row = 0; row < height; ++row) {
            this.addRowNames(row, (ILogicalTable)this.rowNamesTable.getRow(row));
        }
        for (int col = 0; col < width; ++col) {
            this.addColumnNames(col, (ILogicalTable)this.columnNamesTable.getColumn(col));
        }
    }

    private void buildReturn() throws SyntaxNodeException {
        SymbolicTypeDefinition symbolicTypeDefinition = null;
        if (this.returnHeaderDefinition != null) {
            symbolicTypeDefinition = this.returnHeaderDefinition.findVarDef(RETURN_NAME);
        }
        if (this.spreadsheet.getHeader().getType() == JavaOpenClass.getOpenClass(SpreadsheetResult.class)) {
            if (this.returnHeaderDefinition != null) {
                throw SyntaxNodeExceptionUtils.createError((String)"If Spreadsheet return type is SpreadsheetResult, no return type is allowed", (ISyntaxNode)symbolicTypeDefinition.getName());
            }
            this.spreadsheet.setResultBuilder(new DefaultResultBuilder());
        } else {
            if (this.spreadsheet.getHeader().getType() == JavaOpenClass.VOID) {
                throw SyntaxNodeExceptionUtils.createError((String)"Spreadsheet can not return 'void' type", (ISyntaxNode)this.tableSyntaxNode);
            }
            if (this.returnHeaderDefinition == null) {
                throw SyntaxNodeExceptionUtils.createError((String)"There should be RETURN row or column for this return type", (ISyntaxNode)this.tableSyntaxNode);
            }
            List<SpreadsheetCell> notEmpty = this.spreadsheet.listNonEmptyCells(this.returnHeaderDefinition);
            switch (notEmpty.size()) {
                case 0: {
                    throw SyntaxNodeExceptionUtils.createError((String)"There is no return expression cell", (ISyntaxNode)symbolicTypeDefinition.getName());
                }
                case 1: {
                    this.spreadsheet.setResultBuilder(new ScalarResultBuilder(notEmpty));
                    break;
                }
                default: {
                    this.spreadsheet.setResultBuilder(new ArrayResultBuilder(notEmpty, this.returnHeaderDefinition.getType()));
                }
            }
        }
    }

    private int calculateNonEmptyCells(SpreadsheetHeaderDefinition headerDefinition) {
        int fromRow = 0;
        int toRow = this.rowNamesTable.getHeight();
        int fromColumn = 0;
        int toColumn = this.columnNamesTable.getWidth();
        if (headerDefinition.isRow()) {
            fromRow = headerDefinition.getRow();
            toRow = fromRow + 1;
        } else {
            fromColumn = headerDefinition.getColumn();
            toColumn = fromColumn + 1;
        }
        int nonEmptyCellsCount = 0;
        for (int columnIndex = fromColumn; columnIndex < toColumn; ++columnIndex) {
            for (int rowIndex = fromRow; rowIndex < toRow; ++rowIndex) {
                ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.rowNamesTable.getRow(rowIndex), (ILogicalTable)this.columnNamesTable.getColumn(columnIndex));
                String value = cell.getSource().getCell(0, 0).getStringValue();
                if (value == null || value.trim().length() <= 0) continue;
                ++nonEmptyCellsCount;
            }
        }
        return nonEmptyCellsCount;
    }

    private IOpenClass deriveCellType(SpreadsheetCell spreadsheetCell, ILogicalTable cell, SpreadsheetHeaderDefinition columnHeader, SpreadsheetHeaderDefinition rowHeader, String cellValue) {
        if (columnHeader != null && columnHeader.getType() != null) {
            return columnHeader.getType();
        }
        if (rowHeader != null && rowHeader.getType() != null) {
            return rowHeader.getType();
        }
        try {
            if (CellLoader.isFormula(cellValue)) {
                return JavaOpenClass.getOpenClass(DoubleValue.class);
            }
            new String2DoubleConvertor().parse(cellValue, null, null);
            return JavaOpenClass.getOpenClass(DoubleValue.class);
        }
        catch (Throwable t) {
            return JavaOpenClass.getOpenClass(StringValue.class);
        }
    }

    private IOpenClass deriveSingleCellReturnType(int cellsCount, SpreadsheetHeaderDefinition headerDefinition) throws SyntaxNodeException {
        IOpenClass returnType = this.spreadsheet.getHeader().getType();
        if (cellsCount < 2) {
            return returnType;
        }
        IAggregateInfo aggregateInfo = returnType.getAggregateInfo();
        if (aggregateInfo == null || aggregateInfo.getComponentType(returnType) == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"The return type is scalar, but there are more than one return cells", (ISyntaxNode)headerDefinition.findVarDef(RETURN_NAME).getName());
        }
        returnType = aggregateInfo.getComponentType(returnType);
        return returnType;
    }

    private IBindingContext getColumnContext(int columnIndex, IBindingContext bindingContext) {
        IBindingContextDelegator columnContext = this.colContexts.get(columnIndex);
        if (columnContext == null) {
            columnContext = this.makeColumnContext(columnIndex, bindingContext);
            this.colContexts.put(columnIndex, columnContext);
        } else {
            columnContext.setDelegate(bindingContext);
        }
        return columnContext;
    }

    private IBindingContext getRowContext(int rowIndex, IBindingContext bindingContext) {
        IBindingContext rowContext = this.rowContexts.get(rowIndex);
        if (rowContext == null) {
            rowContext = this.makeRowContext(rowIndex, bindingContext);
            this.rowContexts.put(rowIndex, rowContext);
        }
        return rowContext;
    }

    private IBindingContextDelegator makeColumnContext(int columnIndex, IBindingContext scxt) {
        String columnName;
        ModuleOpenClass returnType = new ModuleOpenClass(null, this.spreadsheet.getName() + "ColType" + columnIndex, this.bindingContext.getOpenL());
        ModuleBindingContext moduleBindingContext = new ModuleBindingContext(scxt, returnType);
        int height = this.spreadsheet.getHeight();
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            SpreadsheetHeaderDefinition headerDefinition = this.rowHeaders.get(rowIndex);
            if (headerDefinition == null) continue;
            SpreadsheetCell cell = this.spreadsheet.getCells()[rowIndex][columnIndex];
            for (SymbolicTypeDefinition typeDefinition : headerDefinition.getVars()) {
                String fieldName = "$" + typeDefinition.getName().getIdentifier();
                SpreadsheetCellField field = new SpreadsheetCellField((IOpenClass)returnType, fieldName, cell);
                returnType.addField((IOpenField)field);
            }
        }
        ConstOpenField columnField = new ConstOpenField("$column", (Object)columnIndex, (IOpenClass)JavaOpenClass.INT);
        returnType.addField((IOpenField)columnField);
        SpreadsheetHeaderDefinition shd = this.rowHeaders.get(columnIndex);
        if (shd != null && (columnName = shd.getFirstname()) != null) {
            ConstOpenField columnNameField = new ConstOpenField("$columnName", (Object)columnName, (IOpenClass)JavaOpenClass.STRING);
            returnType.addField((IOpenField)columnNameField);
        }
        return moduleBindingContext;
    }

    private IString2DataConvertor makeConvertor(IOpenClass type) {
        Class instanceClass = type.getInstanceClass();
        if (instanceClass == null) {
            throw new OpenLRuntimeException(String.format("Type '%s' was loaded with errors", type.getName()));
        }
        return String2DataConvertorFactory.getConvertor(instanceClass);
    }

    private IOpenMethodHeader makeHeader(String name, IOpenMethodHeader header, IOpenClass type) {
        return new OpenMethodHeader(name, type, header.getSignature(), header.getDeclaringClass());
    }

    private IBindingContextDelegator makeRowContext(int rowIndex, IBindingContext scxt) {
        String rowName;
        ModuleOpenClass returnType = new ModuleOpenClass(null, this.spreadsheet.getName() + "RowType" + rowIndex, this.bindingContext.getOpenL());
        ModuleBindingContext moduleBindingContext = new ModuleBindingContext(scxt, returnType);
        int width = this.spreadsheet.getWidth();
        for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
            SpreadsheetHeaderDefinition headerDefinition = this.columnHeaders.get(columnIndex);
            if (headerDefinition == null) continue;
            SpreadsheetCell cell = this.spreadsheet.getCells()[rowIndex][columnIndex];
            for (SymbolicTypeDefinition typeDefinition : headerDefinition.getVars()) {
                String fieldName = "$" + typeDefinition.getName().getIdentifier();
                SpreadsheetCellField field = new SpreadsheetCellField((IOpenClass)returnType, fieldName, cell);
                returnType.addField((IOpenField)field);
            }
        }
        ConstOpenField rowField = new ConstOpenField("$row", (Object)rowIndex, (IOpenClass)JavaOpenClass.INT);
        returnType.addField((IOpenField)rowField);
        SpreadsheetHeaderDefinition shd = this.rowHeaders.get(rowIndex);
        if (shd != null && (rowName = shd.getFirstname()) != null) {
            ConstOpenField rowNameField = new ConstOpenField("$rowName", (Object)rowName, (IOpenClass)JavaOpenClass.STRING);
            returnType.addField((IOpenField)rowNameField);
        }
        return moduleBindingContext;
    }

    private void parseHeader(SpreadsheetHeaderDefinition header, StringValue value) {
        try {
            SymbolicTypeDefinition parsed = this.parseHeaderElement(value);
            String headerName = parsed.getName().getIdentifier();
            SpreadsheetHeaderDefinition h1 = this.varDefinitions.get(headerName);
            if (h1 != null) {
                throw new DuplicatedVarException(null, headerName);
            }
            this.varDefinitions.put(headerName, header);
            header.addVarHeader(parsed);
        }
        catch (Throwable t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Cannot parse spreadsheet header definition", (Throwable)t, null, (IOpenSourceCodeModule)value.asSourceCodeModule());
            this.tableSyntaxNode.addError(error);
            BindHelper.processError((SyntaxNodeException)error, (IBindingContext)this.bindingContext);
        }
    }

    private SymbolicTypeDefinition parseHeaderElement(StringValue value) throws SyntaxNodeException {
        IdentifierNode[] nodes;
        IOpenSourceCodeModule source = value.asSourceCodeModule();
        try {
            nodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)":");
        }
        catch (OpenLCompilationException e) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", (IOpenSourceCodeModule)source);
        }
        switch (nodes.length) {
            case 1: {
                return new SymbolicTypeDefinition(nodes[0], null);
            }
            case 2: {
                return new SymbolicTypeDefinition(nodes[0], nodes[1]);
            }
        }
        throw SyntaxNodeExceptionUtils.createError((String)"Valid header format: name [: type]", (IOpenSourceCodeModule)source);
    }

    private void processReturnCells() throws SyntaxNodeException {
        SpreadsheetHeaderDefinition headerDefinition = this.varDefinitions.get(RETURN_NAME);
        if (headerDefinition == null) {
            return;
        }
        int nonEmptyCellsCount = this.calculateNonEmptyCells(headerDefinition);
        IOpenClass cellType = this.deriveSingleCellReturnType(nonEmptyCellsCount, headerDefinition);
        if (headerDefinition.getType() != null) {
            String message = String.format("RETURN %s derives it's type from the Spreadsheet return type and therefore must not be defined here", headerDefinition.rowOrColumn());
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)headerDefinition.getVars().get(0).getName());
        }
        headerDefinition.setType(cellType);
        this.returnHeaderDefinition = headerDefinition;
    }
}

