/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetHeaderDefinition {
    private int row;
    private int column;
    private IOpenClass type;
    private List<SymbolicTypeDefinition> vars = new ArrayList<SymbolicTypeDefinition>();

    public SpreadsheetHeaderDefinition(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public IOpenClass getType() {
        return this.type;
    }

    public List<SymbolicTypeDefinition> getVars() {
        return this.vars;
    }

    public void setType(IOpenClass type) {
        this.type = type;
    }

    public void addVarHeader(SymbolicTypeDefinition parsed) {
        this.vars.add(parsed);
    }

    public SymbolicTypeDefinition findVarDef(String name) {
        for (SymbolicTypeDefinition sdef : this.vars) {
            if (!sdef.getName().getIdentifier().equals(name)) continue;
            return sdef;
        }
        return null;
    }

    public Object getArray(SpreadsheetResultCalculator target, IRuntimeEnv env) {
        if (this.row < 0) {
            return target.getColumn(this.column, env);
        }
        return target.getRow(this.row, env);
    }

    public String getFirstname() {
        for (SymbolicTypeDefinition definition : this.vars) {
            if (definition == null || definition.getName() == null) continue;
            return definition.getName().getIdentifier();
        }
        return null;
    }

    public boolean isRow() {
        return this.row >= 0;
    }

    public String rowOrColumn() {
        return this.isRow() ? "row" : "column";
    }
}

