/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.trace.SpreadsheetTraceObject;
import org.openl.rules.table.DefaultInvokerWithTrace;
import org.openl.types.IDynamicObject;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.DefaultTracePrinter;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class SpreadsheetInvoker
extends DefaultInvokerWithTrace {
    private final Log LOG = LogFactory.getLog(SpreadsheetInvoker.class);
    private Spreadsheet spreadsheet;

    public SpreadsheetInvoker(Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
    }

    public boolean canInvoke() {
        return this.spreadsheet.getResultBuilder() != null;
    }

    public SpreadsheetTraceObject createTraceObject(Object[] params) {
        return new SpreadsheetTraceObject(this.spreadsheet, params);
    }

    public OpenLRuntimeException getError() {
        return new OpenLRuntimeException((Throwable)this.spreadsheet.getSyntaxNode().getErrors()[0]);
    }

    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        SpreadsheetResultCalculator res = new SpreadsheetResultCalculator(this.spreadsheet, (IDynamicObject)target, params, env);
        return this.spreadsheet.getResultBuilder().makeResult(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeTraced(Object target, Object[] params, IRuntimeEnv env) {
        Tracer tracer = Tracer.getTracer();
        Object result = null;
        SpreadsheetTraceObject traceObject = this.createTraceObject(params);
        tracer.push((ITracerObject)traceObject);
        try {
            SpreadsheetResultCalculator res = new SpreadsheetResultCalculator(this.spreadsheet, (IDynamicObject)target, params, env, traceObject);
            result = this.spreadsheet.getResultBuilder().makeResult(res);
            traceObject.setResult(result);
        }
        catch (RuntimeException e) {
            traceObject.setError(e);
            this.LOG.error((Object)"Error when tracing Spreadsheet table", (Throwable)e);
            throw e;
        }
        finally {
            tracer.pop();
            DefaultTracePrinter printer = new DefaultTracePrinter();
            try {
                PrintWriter writer = new PrintWriter(new File("D:/out.txt"));
                printer.print(tracer, (Writer)writer);
                ((Writer)writer).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

