/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetResult
implements Serializable {
    private static final long serialVersionUID = 8704762477153429384L;
    private Object[][] results;
    private int height;
    private int width;
    private String[] columnNames;
    private String[] rowNames;
    private Map<String, Point> fieldsCoordinates;
    private transient ILogicalTable logicalTable;

    public SpreadsheetResult(Object[][] results, String[] rowNames, String[] columnNames, Map<String, Point> fieldsCoordinates) {
        this.columnNames = columnNames;
        this.rowNames = rowNames;
        this.height = rowNames.length;
        this.width = columnNames.length;
        this.results = (Object[][])results.clone();
        this.fieldsCoordinates = new HashMap<String, Point>(fieldsCoordinates);
    }

    @Deprecated
    public int height() {
        return this.getHeight();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Object[][] getResults() {
        return (Object[][])this.results.clone();
    }

    public void setResults(Object[][] results) {
        this.results = (Object[][])results.clone();
    }

    @Deprecated
    public int width() {
        return this.getWidth();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = (String[])rowNames.clone();
    }

    public Object getValue(int row, int column) {
        return this.results[row][column];
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public String getRowName(int row) {
        return this.rowNames[row];
    }

    public Map<String, Point> getFieldsCoordinates() {
        return new HashMap<String, Point>(this.fieldsCoordinates);
    }

    public void setFieldsCoordinates(Map<String, Point> fieldsCoordinates) {
        this.fieldsCoordinates = new HashMap<String, Point>(fieldsCoordinates);
    }

    public ILogicalTable getLogicalTable() {
        return this.logicalTable;
    }

    public void setLogicalTable(ILogicalTable logicalTable) {
        this.logicalTable = logicalTable;
    }

    public Object getFieldValue(String name) {
        Point fieldCoordinates = this.fieldsCoordinates.get(name);
        if (fieldCoordinates != null) {
            return this.getValue(fieldCoordinates.getRow(), fieldCoordinates.getColumn());
        }
        return null;
    }
}

