/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Map;
import org.openl.binding.IBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.trace.SpreadsheetTraceObject;
import org.openl.rules.calc.trace.SpreadsheetTracerLeaf;
import org.openl.types.IDynamicObject;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetResultCalculator
implements IDynamicObject {
    private Spreadsheet spreadsheet;
    private boolean cacheResult = true;
    private SpreadsheetTraceObject spreadsheetTraceObject;
    private IDynamicObject targetModule;
    private Object[] params;
    private IRuntimeEnv env;
    private Object[][] results;

    public SpreadsheetResultCalculator(Spreadsheet spreadsheet, IDynamicObject targetModule, Object[] params, IRuntimeEnv env) {
        this.spreadsheet = spreadsheet;
        this.targetModule = targetModule;
        this.params = params;
        this.env = env;
        this.results = new Object[spreadsheet.getHeight()][spreadsheet.getWidth()];
    }

    public SpreadsheetResultCalculator(Spreadsheet spreadsheet, IDynamicObject targetModule, Object[] params, IRuntimeEnv env, SpreadsheetTraceObject spreadsheetTraceObject) {
        this.spreadsheet = spreadsheet;
        this.targetModule = targetModule;
        this.params = params;
        this.env = env;
        this.results = new Object[spreadsheet.getHeight()][spreadsheet.getWidth()];
        this.spreadsheetTraceObject = spreadsheetTraceObject;
    }

    public Object getColumn(int column, IRuntimeEnv env2) {
        return null;
    }

    public String getColumnName(int column) {
        return this.spreadsheet.getColumnNames()[column];
    }

    public Object getFieldValue(String name) {
        IOpenField field = this.spreadsheet.getSpreadsheetType().getField(name);
        if (field == null) {
            return this.targetModule.getFieldValue(name);
        }
        SpreadsheetCellField cellField = (SpreadsheetCellField)field;
        int row = cellField.getCell().getRowIndex();
        int column = cellField.getCell().getColumnIndex();
        return this.getValue(row, column);
    }

    public Map<String, Object> getFieldValues() {
        throw new UnsupportedOperationException("Should not be called, this is only used in NicePrinter");
    }

    public Object getRow(int row, IRuntimeEnv env) {
        return null;
    }

    public String getRowName(int row) {
        return this.spreadsheet.getRowNames()[row];
    }

    public int getRowIndex(String name) {
        String[] names = this.spreadsheet.getRowNames();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        throw new OpenLRuntimeException("Row name <" + name + "> not found", (IBoundNode)this.spreadsheet.getBoundNode());
    }

    public int getColumnIndex(String name) {
        String[] names = this.spreadsheet.getColumnNames();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return i;
        }
        throw new OpenLRuntimeException("Column name <" + name + "> not found", (IBoundNode)this.spreadsheet.getBoundNode());
    }

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public IOpenClass getType() {
        return this.spreadsheet.getSpreadsheetType();
    }

    private boolean isTraceOn() {
        return this.spreadsheetTraceObject != null;
    }

    public Object getValue(int row, int column) {
        SpreadsheetCell spreadsheetCell = this.spreadsheet.getCells()[row][column];
        if (this.isTraceOn() && spreadsheetCell.getKind() != SpreadsheetCellType.EMPTY) {
            this.getValueTraced(row, column);
        }
        Object result = null;
        if (this.cacheResult && (result = this.results[row][column]) != null) {
            return result;
        }
        this.results[row][column] = result = spreadsheetCell.calculate(this, this.targetModule, this.params, this.env);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueTraced(int row, int column) {
        SpreadsheetCell spreadsheetCell = this.spreadsheet.getCells()[row][column];
        Tracer tracer = Tracer.getTracer();
        SpreadsheetTracerLeaf spreadsheetTraceLeaf = new SpreadsheetTracerLeaf(this.spreadsheetTraceObject, spreadsheetCell);
        tracer.push((ITracerObject)spreadsheetTraceLeaf);
        Object result = null;
        try {
            if (this.cacheResult && (result = this.results[row][column]) != null) {
                spreadsheetTraceLeaf.setValue(result);
                Object object = result;
                return object;
            }
            this.results[row][column] = result = spreadsheetCell.calculate(this, this.targetModule, this.params, this.env);
            spreadsheetTraceLeaf.setValue(result);
            Object object = result;
            return object;
        }
        finally {
            tracer.pop();
        }
    }

    public final int height() {
        return this.spreadsheet.getHeight();
    }

    public void setFieldValue(String name, Object value) {
    }

    public String toString() {
        return "Spreadsheet[" + this.width() + " x " + this.height() + "]";
    }

    public final int width() {
        return this.spreadsheet.getWidth();
    }
}

