/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.engine.OpenLManager;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenMethodHeader;

public class CellLoader {
    private IBindingContext bindingContext;
    private IOpenMethodHeader header;
    private IString2DataConvertor convertor;

    public CellLoader(IBindingContext bindingContext, IOpenMethodHeader header, IString2DataConvertor convertor) {
        this.bindingContext = bindingContext;
        this.header = header;
        this.convertor = convertor;
    }

    public Object loadSingleParam(IOpenSourceCodeModule source, IMetaInfo meta) throws SyntaxNodeException {
        String code = source.getCode();
        if (code == null || (code = code.trim()).length() == 0) {
            return null;
        }
        if (this.bindingContext != null && CellLoader.isFormula(code)) {
            int end = 0;
            if (code.startsWith("{")) {
                end = -1;
            }
            SubTextSourceCodeModule srcCode = new SubTextSourceCodeModule(source, 1, end);
            return OpenLManager.makeMethod((OpenL)this.bindingContext.getOpenL(), (IOpenSourceCodeModule)srcCode, (IOpenMethodHeader)this.header, (IBindingContext)this.bindingContext);
        }
        try {
            Object result = this.convertor.parse(code, null, this.bindingContext);
            if (result instanceof IMetaHolder) {
                ((IMetaHolder)result).setMetaInfo(meta);
            }
            return result;
        }
        catch (Throwable t) {
            throw SyntaxNodeExceptionUtils.createError(null, (Throwable)t, null, (IOpenSourceCodeModule)source);
        }
    }

    public static boolean isFormula(String src) {
        if (StringUtils.isBlank((String)src)) {
            return false;
        }
        if (src.startsWith("{") && src.endsWith("}")) {
            return true;
        }
        return src.startsWith("=") && (src.length() > 2 || src.length() == 2 && Character.isLetterOrDigit(src.charAt(1)));
    }
}

