/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.AnyCellValue;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCell {
    private int rowIndex;
    private int columnIndex;
    private ICell sourceCell;
    private SpreadsheetCellType kind = SpreadsheetCellType.EMPTY;
    private Object value;
    private IOpenClass type;
    private IOpenMethod method;

    public SpreadsheetCell(int rowIndex, int columnIndex, ICell sourceCell) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.sourceCell = sourceCell;
    }

    public ICell getSourceCell() {
        return this.sourceCell;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public SpreadsheetCellType getKind() {
        return this.kind;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public IOpenClass getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.kind == SpreadsheetCellType.EMPTY;
    }

    public boolean isMethodCell() {
        return this.kind == SpreadsheetCellType.METHOD;
    }

    public boolean isValueCell() {
        return this.kind == SpreadsheetCellType.VALUE;
    }

    public void setKind(SpreadsheetCellType kind) {
        this.kind = kind;
    }

    public void setMethod(IOpenMethod method) {
        this.method = method;
    }

    public void setType(IOpenClass type) {
        this.type = type;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.kind = SpreadsheetCellType.EMPTY;
        } else if (value instanceof IOpenMethod) {
            this.kind = SpreadsheetCellType.METHOD;
            this.method = (IOpenMethod)value;
        } else {
            this.value = value;
            this.kind = SpreadsheetCellType.VALUE;
        }
    }

    public Object calculate(SpreadsheetResultCalculator spreadsheetResult, Object targetModule, Object[] params, IRuntimeEnv env) {
        if (this.isValueCell()) {
            Object value = this.getValue();
            if (value instanceof AnyCellValue) {
                return ((AnyCellValue)value).getValue();
            }
            return value;
        }
        if (this.isMethodCell()) {
            return this.getMethod().invoke((Object)spreadsheetResult, params, env);
        }
        return null;
    }
}

