/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result;

import java.lang.reflect.Array;
import java.util.List;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.types.IOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayResultBuilder
implements IResultBuilder {
    private IOpenClass type;
    private List<SpreadsheetCell> cells;

    public ArrayResultBuilder(List<SpreadsheetCell> notEmpty, IOpenClass type) {
        this.cells = notEmpty;
        this.type = type;
    }

    @Override
    public Object makeResult(SpreadsheetResultCalculator resultCalculator) {
        int size = this.cells.size();
        Object array = this.type.getAggregateInfo().makeIndexedAggregate(this.type, new int[]{size});
        for (int i = 0; i < size; ++i) {
            SpreadsheetCell cell = this.cells.get(i);
            Object value = resultCalculator.getValue(cell.getRowIndex(), cell.getColumnIndex());
            if (value == null) {
                value = this.type.nullObject();
            }
            Array.set(array, i, value);
        }
        return array;
    }
}

