/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.trace;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.trace.SpreadsheetTraceObject;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ATableTracerLeaf;
import org.openl.rules.table.IGridRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetTracerLeaf
extends ATableTracerLeaf {
    private static final String SPREADSHEET_CELL_TYPE = "spreadsheetCell";
    private SpreadsheetTraceObject spreadsheetTraceObject;
    private SpreadsheetCell spreadsheetCell;
    private Object result;

    public SpreadsheetTracerLeaf(SpreadsheetTraceObject spreadsheetTraceObject, SpreadsheetCell spreadsheetCell) {
        super(spreadsheetCell);
        this.spreadsheetTraceObject = spreadsheetTraceObject;
        this.spreadsheetCell = spreadsheetCell;
    }

    public Object getValue() {
        return this.result;
    }

    public void setValue(Object value) {
        this.result = value;
    }

    public String getUri() {
        return this.spreadsheetCell.getSourceCell().getUri();
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        regions.add(this.spreadsheetCell.getSourceCell().getAbsoluteRegion());
        return regions;
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.spreadsheetTraceObject.getTableSyntaxNode();
    }

    public String getType() {
        return SPREADSHEET_CELL_TYPE;
    }

    public String getDisplayName(int mode) {
        StringBuilder buf = new StringBuilder(64);
        buf.append("Spreadsheet cell [");
        Spreadsheet spreadsheet = this.spreadsheetTraceObject.getSpreadsheet();
        buf.append(String.format("$%s", spreadsheet.getRowNames()[this.spreadsheetCell.getRowIndex()]));
        buf.append(String.format("$%s", spreadsheet.getColumnNames()[this.spreadsheetCell.getColumnIndex()]));
        buf.append("]");
        buf.append(" = ").append(String.valueOf(this.result));
        return buf.toString();
    }
}

