/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.rules.cmatch.algorithm.ColumnMatchTraceObject;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmExecutor;
import org.openl.rules.cmatch.algorithm.MatchTraceObject;
import org.openl.rules.cmatch.algorithm.ResultTraceObject;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class MatchAlgorithmExecutor
implements IMatchAlgorithmExecutor {
    public static final Object NO_MATCH = null;

    private void fillNoMatchTracer(ColumnMatch columnMatch, Object[] params) {
        Tracer t = Tracer.getTracer();
        if (t == null) {
            return;
        }
        ColumnMatchTraceObject traceObject = new ColumnMatchTraceObject(columnMatch, params);
        traceObject.setResult(NO_MATCH);
        t.push((ITracerObject)traceObject);
        t.pop();
    }

    private void fillTracer(ColumnMatch columnMatch, MatchNode line, int resultIndex, Object[] params) {
        Tracer t = Tracer.getTracer();
        if (t == null) {
            return;
        }
        ColumnMatchTraceObject traceObject = new ColumnMatchTraceObject(columnMatch, params);
        Object[] returnValues = columnMatch.getReturnValues();
        traceObject.setResult(returnValues[resultIndex]);
        t.push((ITracerObject)traceObject);
        for (MatchNode node : line.getChildren()) {
            t.push((ITracerObject)new MatchTraceObject(columnMatch, node.getRowIndex(), resultIndex));
            t.pop();
        }
        t.push((ITracerObject)new ResultTraceObject(columnMatch, resultIndex));
        t.pop();
        t.pop();
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env, ColumnMatch columnMatch) {
        MatchNode checkTree = columnMatch.getCheckTree();
        Object[] returnValues = columnMatch.getReturnValues();
        for (MatchNode line : checkTree.getChildren()) {
            if (line.getRowIndex() >= 0) {
                throw new IllegalArgumentException("Linearized MatchNode tree expected!");
            }
            for (int resultIndex = 0; resultIndex < returnValues.length; ++resultIndex) {
                boolean success = true;
                for (MatchNode node : line.getChildren()) {
                    Object checkValue;
                    Argument arg = node.getArgument();
                    Object var = arg.extractValue(target, params, env);
                    IMatcher matcher = node.getMatcher();
                    if (matcher.match(var, checkValue = node.getCheckValues()[resultIndex])) continue;
                    success = false;
                    break;
                }
                if (!success) continue;
                this.fillTracer(columnMatch, line, resultIndex, params);
                return returnValues[resultIndex];
            }
        }
        this.fillNoMatchTracer(columnMatch, params);
        return NO_MATCH;
    }
}

