/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.SubValue;
import org.openl.rules.cmatch.TableRow;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ATableTracerLeaf;
import org.openl.rules.table.IGridRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchTraceObject
extends ATableTracerLeaf {
    private ColumnMatch columnMatch;
    private int rowIndex;
    private int resultIndex;

    public MatchTraceObject(ColumnMatch columnMatch, int rowIndex, int resultIndex) {
        this.columnMatch = columnMatch;
        this.rowIndex = rowIndex;
        this.resultIndex = resultIndex;
    }

    public String getDisplayName(int mode) {
        TableRow row = this.getRow();
        String operation = row.get("operation")[0].getString();
        String checkValue = row.get("values")[this.resultIndex].getString();
        return "Match: " + operation + " " + checkValue;
    }

    @Override
    public List<IGridRegion> getGridRegions() {
        TableRow row = this.columnMatch.getRows().get(this.rowIndex);
        ArrayList<IGridRegion> regions = new ArrayList<IGridRegion>();
        regions.add(row.get("values")[this.resultIndex].getGridRegion());
        return regions;
    }

    protected int getResultIndex() {
        return this.resultIndex;
    }

    protected TableRow getRow() {
        return this.columnMatch.getRows().get(this.rowIndex);
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.columnMatch.getSyntaxNode();
    }

    public String getType() {
        return "cmMatch";
    }

    public String getUri() {
        TableRow row = this.columnMatch.getRows().get(this.rowIndex);
        SubValue sv = row.get("values")[this.resultIndex];
        return sv.getStringValue().getMetaInfo().getSourceUrl();
    }
}

