/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.rules.cmatch.algorithm.ColumnMatchTraceObject;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmExecutor;
import org.openl.rules.cmatch.algorithm.MatchTraceObject;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class ScoreAlgorithmExecutor
implements IMatchAlgorithmExecutor {
    public Object invoke(Object target, Object[] params, IRuntimeEnv env, ColumnMatch columnMatch) {
        TraceHelper t = new TraceHelper(columnMatch, params);
        MatchNode checkTree = columnMatch.getCheckTree();
        int[] scores = columnMatch.getColumnScores();
        int sumScore = 0;
        block0: for (MatchNode node : checkTree.getChildren()) {
            if (!node.isLeaf()) {
                throw new IllegalArgumentException("Sub node are prohibited here!");
            }
            Argument arg = node.getArgument();
            Object var = arg.extractValue(target, params, env);
            IMatcher matcher = node.getMatcher();
            for (int resultIndex = 0; resultIndex < scores.length; ++resultIndex) {
                Object checkValue = node.getCheckValues()[resultIndex];
                if (!matcher.match(var, checkValue)) continue;
                int score = scores[resultIndex] * node.getWeight();
                t.nextScore(node, resultIndex, sumScore += score, score);
                continue block0;
            }
        }
        t.closeMatch(sumScore);
        return sumScore;
    }

    private static class TraceHelper {
        private final Tracer tracer = Tracer.getTracer();
        private ColumnMatch columnMatch;
        private ColumnMatchTraceObject traceObject;

        public TraceHelper(ColumnMatch columnMatch, Object[] params) {
            if (this.tracer != null) {
                this.columnMatch = columnMatch;
                this.traceObject = new ColumnMatchTraceObject(columnMatch, params);
                this.tracer.push((ITracerObject)this.traceObject);
            }
        }

        public void closeMatch(int sumScore) {
            if (this.tracer == null) {
                return;
            }
            this.traceObject.setResult(sumScore);
            this.tracer.pop();
        }

        public void nextScore(MatchNode node, int resultIndex, int sumScore, int score) {
            if (this.tracer == null) {
                return;
            }
            this.tracer.push((ITracerObject)new MatchTraceObject(this.columnMatch, node.getRowIndex(), resultIndex));
            this.tracer.pop();
        }
    }
}

