/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmExecutor;
import org.openl.rules.cmatch.algorithm.MatchTraceObject;
import org.openl.rules.cmatch.algorithm.ResultTraceObject;
import org.openl.rules.cmatch.algorithm.WColumnMatchTraceObject;
import org.openl.rules.cmatch.algorithm.WScoreTraceObject;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class WeightAlgorithmExecutor
implements IMatchAlgorithmExecutor {
    public static final Object NO_MATCH = null;

    public Object invoke(Object target, Object[] params, IRuntimeEnv env, ColumnMatch columnMatch) {
        TraceHelper t = new TraceHelper(columnMatch, params);
        MatchNode checkTree = columnMatch.getCheckTree();
        Object[] returnValues = columnMatch.getReturnValues();
        int sumScore = 0;
        block0: for (MatchNode node : checkTree.getChildren()) {
            if (!node.isLeaf()) {
                throw new IllegalArgumentException("Sub node are prohibited here!");
            }
            Argument arg = node.getArgument();
            Object var = arg.extractValue(target, params, env);
            IMatcher matcher = node.getMatcher();
            for (int resultIndex = 0; resultIndex < returnValues.length; ++resultIndex) {
                Object checkValue = node.getCheckValues()[resultIndex];
                if (!matcher.match(var, checkValue)) continue;
                int score = columnMatch.getColumnScores()[resultIndex] * node.getWeight();
                t.nextScore(node, resultIndex, sumScore += score, score);
                continue block0;
            }
        }
        MatchNode totalScore = columnMatch.getTotalScore();
        IMatcher matcher = totalScore.getMatcher();
        for (int resultIndex = 0; resultIndex < returnValues.length; ++resultIndex) {
            Object checkValue = totalScore.getCheckValues()[resultIndex];
            if (!matcher.match(sumScore, checkValue)) continue;
            t.closeMatch(sumScore, resultIndex);
            return returnValues[resultIndex];
        }
        t.closeNoMatch();
        return NO_MATCH;
    }

    private static class TraceHelper {
        private final Tracer tracer = Tracer.getTracer();
        private ColumnMatch columnMatch;
        private WColumnMatchTraceObject traceObject;
        private WScoreTraceObject wScore;

        public TraceHelper(ColumnMatch columnMatch, Object[] params) {
            if (this.tracer != null) {
                this.columnMatch = columnMatch;
                this.traceObject = new WColumnMatchTraceObject(columnMatch, params);
                this.tracer.push((ITracerObject)this.traceObject);
                this.wScore = new WScoreTraceObject(columnMatch);
                this.tracer.push((ITracerObject)this.wScore);
            }
        }

        public void closeMatch(int sumScore, int resultIndex) {
            if (this.tracer == null) {
                return;
            }
            this.tracer.pop();
            this.tracer.push((ITracerObject)new MatchTraceObject(this.columnMatch, 1, resultIndex));
            this.tracer.pop();
            this.tracer.push((ITracerObject)new ResultTraceObject(this.columnMatch, resultIndex));
            this.tracer.pop();
            this.traceObject.setResult(this.columnMatch.getReturnValues()[resultIndex]);
            this.tracer.pop();
        }

        public void closeNoMatch() {
            if (this.tracer == null) {
                return;
            }
            this.tracer.pop();
            this.traceObject.setResult(NO_MATCH);
            this.tracer.pop();
        }

        public void nextScore(MatchNode node, int resultIndex, int sumScore, int score) {
            if (this.tracer == null) {
                return;
            }
            this.wScore.setScore(sumScore);
            this.tracer.push((ITracerObject)new MatchTraceObject(this.columnMatch, node.getRowIndex(), resultIndex));
            this.tracer.pop();
        }
    }
}

