/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.openl.binding.IBindingContext;
import org.openl.meta.DoubleValue;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;
import org.openl.rules.helpers.IntRange;
import org.openl.util.RuntimeExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectToDataConvertorFactory {
    private static Map<ClassCastPair, IObjectToDataConvertor> convertors = new HashMap<ClassCastPair, IObjectToDataConvertor>();
    public static final IObjectToDataConvertor NO_Convertor;

    public static synchronized IObjectToDataConvertor getConvertor(Class<?> toClass, Class<?> fromClass) {
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        IObjectToDataConvertor convertor = NO_Convertor;
        if (!convertors.containsKey(pair)) {
            Constructor ctr = ConstructorUtils.getMatchingAccessibleConstructor(toClass, (Class[])new Class[]{fromClass});
            convertor = ctr != null ? new MatchedConstructorConvertor(ctr) : NO_Convertor;
            convertors.put(pair, convertor);
        } else {
            convertor = convertors.get(pair);
        }
        return convertor;
    }

    public static IObjectToDataConvertor registerConvertor(Class<?> toClass, Class<?> fromClass, IObjectToDataConvertor convertor) {
        ClassCastPair pair = new ClassCastPair(fromClass, toClass);
        return convertors.put(pair, convertor);
    }

    static {
        try {
            convertors.put(new ClassCastPair(Integer.class, IntRange.class), new IObjectToDataConvertor(){

                public Object convert(Object data, IBindingContext bindingContext) {
                    return new IntRange((Integer)data);
                }
            });
            convertors.put(new ClassCastPair(Double.class, DoubleValue.class), new IObjectToDataConvertor(){

                public Object convert(Object data, IBindingContext bindingContext) {
                    return new DoubleValue(((Double)data).doubleValue());
                }
            });
            convertors.put(new ClassCastPair(Double.class, Double.class), new CopyConvertor());
            convertors.put(new ClassCastPair(Double.class, Double.TYPE), new CopyConvertor());
            convertors.put(new ClassCastPair(Integer.class, Integer.TYPE), new CopyConvertor());
            convertors.put(new ClassCastPair(String.class, String.class), new CopyConvertor());
            convertors.put(new ClassCastPair(Date.class, Date.class), new CopyConvertor());
            convertors.put(new ClassCastPair(Date.class, Calendar.class), new IObjectToDataConvertor(){

                public Object convert(Object data, IBindingContext bindingContext) {
                    Calendar cal = Calendar.getInstance(LocaleDependConvertor.getLocale());
                    cal.setTime((Date)data);
                    return cal;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NO_Convertor = new IObjectToDataConvertor(){

            public Object convert(Object data, IBindingContext bindingContext) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class CopyConvertor
    implements IObjectToDataConvertor {
        public Object convert(Object data, IBindingContext bindingContext) {
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatchedConstructorConvertor
    implements IObjectToDataConvertor {
        private Constructor<?> ctr;

        public MatchedConstructorConvertor(Constructor<?> ctr) {
            this.ctr = ctr;
        }

        @Override
        public Object convert(Object data, IBindingContext bindingContext) {
            try {
                return this.ctr.newInstance(data);
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassCastPair {
        private Class<?> from;
        private Class<?> to;

        public ClassCastPair(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            return this.to.hashCode() + this.from.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassCastPair)) {
                return false;
            }
            ClassCastPair pair = (ClassCastPair)obj;
            return this.from == pair.from && this.to == pair.to;
        }
    }
}

