/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.openl.binding.IBindingContext;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.util.ArrayTool;
import org.openl.util.Log;
import org.openl.util.StringTool;

public class String2ArrayConvertor
implements IString2DataConvertor {
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    private IString2DataConvertor elementFormat;

    public String2ArrayConvertor(IString2DataConvertor elementFormat) {
        this.elementFormat = elementFormat;
    }

    public String format(Object value, String format) {
        String result = null;
        if (value != null) {
            if (!value.getClass().isArray()) {
                Log.error((Object)String.format("Should be an array: ", value.toString()));
                return result;
            }
            Object[] array = ArrayTool.toArray((Object)value);
            Object[] elementResults = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                elementResults[i] = this.elementFormat.format(element, format);
                result = StringUtils.join((Object[])elementResults, (String)ARRAY_ELEMENTS_SEPARATOR);
            }
        }
        return result;
    }

    public Object parse(String data, String format, IBindingContext bindingContext) {
        Object[] result = null;
        if (StringUtils.isNotEmpty((String)data)) {
            String[] elementValues = StringTool.splitAndEscape((String)data, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
            ArrayList<Object> elements = new ArrayList<Object>();
            Class<?> elementType = null;
            for (String elementValue : elementValues) {
                Object element = this.elementFormat.parse(elementValue, format, bindingContext);
                elements.add(element);
                elementType = element.getClass();
            }
            if (elementType == null) {
                return result;
            }
            Object[] resultArray = (Object[])Array.newInstance(elementType, elements.size());
            result = elements.toArray(resultArray);
        }
        return result;
    }
}

