/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.openl.meta.DoubleValue;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.NoConvertor;
import org.openl.rules.convertor.String2ArrayConvertor;
import org.openl.rules.convertor.String2BooleanConvertor;
import org.openl.rules.convertor.String2ByteConvertor;
import org.openl.rules.convertor.String2CalendarConvertor;
import org.openl.rules.convertor.String2CharConvertor;
import org.openl.rules.convertor.String2ClassConvertor;
import org.openl.rules.convertor.String2ConstructorConvertor;
import org.openl.rules.convertor.String2DateConvertor;
import org.openl.rules.convertor.String2DoubleConvertor;
import org.openl.rules.convertor.String2DoubleValueConvertor;
import org.openl.rules.convertor.String2EnumConvertor;
import org.openl.rules.convertor.String2FloatConvertor;
import org.openl.rules.convertor.String2IntConvertor;
import org.openl.rules.convertor.String2IntRangeConvertor;
import org.openl.rules.convertor.String2LongConvertor;
import org.openl.rules.convertor.String2OpenClassConvertor;
import org.openl.rules.convertor.String2ShortConvertor;
import org.openl.rules.convertor.String2StringConvertor;
import org.openl.rules.helpers.IntRange;
import org.openl.types.IOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2DataConvertorFactory {
    private static HashMap<Class<?>, IString2DataConvertor> convertors = new HashMap();

    public static synchronized IString2DataConvertor getConvertor(Class<?> clazz) {
        IString2DataConvertor convertor = convertors.get(clazz);
        if (convertor != null) {
            return convertor;
        }
        if (clazz.isEnum()) {
            convertor = new String2EnumConvertor(clazz);
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            IString2DataConvertor componentConvertor = String2DataConvertorFactory.getConvertor(componentType);
            convertor = new String2ArrayConvertor(componentConvertor);
        } else {
            try {
                Constructor<?> ctr = clazz.getDeclaredConstructor(String.class);
                convertor = new String2ConstructorConvertor(ctr);
            }
            catch (NoSuchMethodException t) {
                convertor = new NoConvertor(clazz);
            }
        }
        convertors.put(clazz, convertor);
        return convertor;
    }

    public static void registerConvertor(Class<?> clazz, IString2DataConvertor conv) {
        convertors.put(clazz, conv);
    }

    public static void unregisterConvertorForClass(Class<?> clazz) {
        convertors.remove(clazz);
    }

    public static void unregisterClassLoader(ClassLoader classLoader) {
        ArrayList toRemove = new ArrayList();
        for (Class<Object> clazz : convertors.keySet()) {
            if (clazz.getClassLoader() != classLoader) continue;
            toRemove.add(clazz);
        }
        for (Class<Object> clazz : toRemove) {
            String2DataConvertorFactory.unregisterConvertorForClass(clazz);
        }
    }

    static {
        convertors.put(Integer.TYPE, new String2IntConvertor());
        convertors.put(Double.TYPE, new String2DoubleConvertor());
        convertors.put(Character.TYPE, new String2CharConvertor());
        convertors.put(Boolean.TYPE, new String2BooleanConvertor());
        convertors.put(Long.TYPE, new String2LongConvertor());
        convertors.put(Byte.TYPE, new String2ByteConvertor());
        convertors.put(Short.TYPE, new String2ShortConvertor());
        convertors.put(Float.TYPE, new String2FloatConvertor());
        convertors.put(Integer.class, new String2IntConvertor());
        convertors.put(Byte.class, new String2ByteConvertor());
        convertors.put(Short.class, new String2ShortConvertor());
        convertors.put(Float.class, new String2FloatConvertor());
        convertors.put(Double.class, new String2DoubleConvertor());
        convertors.put(Character.class, new String2CharConvertor());
        convertors.put(Boolean.class, new String2BooleanConvertor());
        convertors.put(Long.class, new String2LongConvertor());
        convertors.put(String.class, new String2StringConvertor());
        convertors.put(Date.class, new String2DateConvertor());
        convertors.put(Calendar.class, new String2CalendarConvertor());
        convertors.put(Class.class, new String2ClassConvertor());
        convertors.put(IOpenClass.class, new String2OpenClassConvertor());
        convertors.put(DoubleValue.class, new String2DoubleValueConvertor());
        convertors.put(IntRange.class, new String2IntRangeConvertor());
    }
}

