/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import org.openl.binding.IBindingContext;
import org.openl.rules.convertor.IString2DataConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class String2EnumConvertor
implements IString2DataConvertor {
    private Class<? extends Enum<?>> enumType;

    public String2EnumConvertor(Class<?> clazz) {
        assert (clazz.isEnum());
        this.enumType = clazz;
    }

    @Override
    public String format(Object data, String format) {
        return this.parse(String.valueOf(data), format, null).toString();
    }

    @Override
    public Object parse(String data, String format, IBindingContext cxt) {
        Enum<?> resolvedConstant = null;
        for (Enum<?> enumConstant : this.enumType.getEnumConstants()) {
            if (!data.equalsIgnoreCase(enumConstant.name())) continue;
            resolvedConstant = enumConstant;
            break;
        }
        if (resolvedConstant == null) {
            throw new RuntimeException(String.format("Constant corresponding to value \"%s\" can't be found in Enum %s ", data, this.enumType.getName()));
        }
        return resolvedConstant;
    }
}

