/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ITable;
import org.openl.rules.data.OpenlBasedDataTableModel;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;

public class DataNodeBinder
extends AXlsTableBinder {
    private static final int HEADER_NUM_TOKENS = 3;
    private static final String FORMAT_ERROR_MESSAGE = "Data table format: Data <typename> <tablename>";
    private static final int TYPE_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;
    private IdentifierNode[] parsedHeader;

    protected String getFormatErrorMessage() {
        return FORMAT_ERROR_MESSAGE;
    }

    protected IOpenClass getTableType(String typeName, IBindingContext bindingContext, XlsModuleOpenClass module, DataTableBoundNode dataNode, String tableName) {
        return bindingContext.findType("org.openl.this", typeName);
    }

    protected ATableBoundNode makeNode(TableSyntaxNode tsn, XlsModuleOpenClass module) {
        return new DataTableBoundNode(tsn, module);
    }

    protected ILogicalTable getTableBody(TableSyntaxNode tsn) {
        return DataTableBindHelper.getTableBody(tsn);
    }

    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        DataTableBoundNode dataNode = (DataTableBoundNode)this.makeNode(tableSyntaxNode, module);
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), bindingContext);
        this.parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        this.checkParsedHeader(source);
        String typeName = this.parsedHeader[1].getIdentifier();
        String tableName = this.parsedHeader[2].getIdentifier();
        IOpenClass tableType = this.getTableType(typeName, bindingContext, module, dataNode, tableName);
        if (tableType == null) {
            String message = String.format("Type not found: '%s'", typeName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.parsedHeader[1]);
        }
        if (tableType.getInstanceClass() == null) {
            String message = String.format("Type '%s' was defined with errors", typeName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.parsedHeader[1]);
        }
        ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, tableType, bindingContext, openl);
        dataNode.setTable(dataTable);
        return dataNode;
    }

    public void processTable(XlsModuleOpenClass xlsOpenClass, ITable tableToProcess, ILogicalTable tableBody, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow) throws Exception {
        if (tableBody == null) {
            String message = "There is no body in Data table.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        ILogicalTable horizDataTableBody = DataTableBindHelper.getHorizontalTable(tableBody, tableType);
        if (horizDataTableBody.getHeight() <= 1) {
            String message = "Invalid table structure: data table body should contain key and value columns.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        ILogicalTable descriptorRows = DataTableBindHelper.getDescriptorRows(horizDataTableBody);
        ILogicalTable dataWithTitleRows = DataTableBindHelper.getHorizontalDataWithTitle(horizDataTableBody);
        dataWithTitleRows = LogicalTableHelper.logicalTable(dataWithTitleRows.getSource(), descriptorRows, null);
        ColumnDescriptor[] descriptors = DataTableBindHelper.makeDescriptors(bindingContext, tableToProcess, tableType, openl, descriptorRows, dataWithTitleRows, DataTableBindHelper.hasForeignKeysRow(horizDataTableBody), hasColumnTitleRow);
        OpenlBasedDataTableModel dataModel = new OpenlBasedDataTableModel(tableName, tableType, openl, descriptors, hasColumnTitleRow);
        OpenlToolAdaptor ota = new OpenlToolAdaptor(openl, bindingContext);
        xlsOpenClass.getDataBase().preLoadTable(tableToProcess, dataModel, dataWithTitleRows, ota);
    }

    private void putSubTableForBussinesView(TableSyntaxNode tableSyntaxNode, IOpenClass tableType) {
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        ILogicalTable dataWithTitle = DataTableBindHelper.getSubTableForBusinessView(tableBody, tableType);
        tableSyntaxNode.getSubTables().put("view.business", dataWithTitle);
    }

    private ITable makeTable(XlsModuleOpenClass xlsOpenClass, TableSyntaxNode tableSyntaxNode, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl) throws Exception {
        ITable resultTable = xlsOpenClass.getDataBase().addNewTable(tableName, tableSyntaxNode);
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        this.processTable(xlsOpenClass, resultTable, tableBody, tableName, tableType, bindingContext, openl, true);
        this.putSubTableForBussinesView(tableSyntaxNode, tableType);
        return resultTable;
    }

    private void checkParsedHeader(IOpenSourceCodeModule source) throws SyntaxNodeException {
        try {
            this.parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        }
        catch (OpenLCompilationException e) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot parse header", null, null, (IOpenSourceCodeModule)source);
        }
        if (this.parsedHeader.length < 3) {
            String message = this.getFormatErrorMessage();
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)source);
        }
    }
}

