/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.StringValue;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.ITable;
import org.openl.rules.data.PrimaryKeyField;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.ArrayTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableBindHelper {
    private static final char INDEX_ROW_REFERENCE_START_SYMBOL = '>';
    private static final String FPK = "_PK_";
    protected static final String CONSTRUCTOR_FIELD = "this";
    private static final String CODE_DELIMETERS = ". \n\r";
    private static final String INDEX_ROW_REFERENCE_DELIMITER = " >\n\r";

    public static boolean hasForeignKeysRow(ILogicalTable dataTable) {
        ILogicalTable potentialForeignKeysRow = (ILogicalTable)dataTable.getRows(1, 1);
        int columnsCount = potentialForeignKeysRow.getWidth();
        for (int i = 0; i < columnsCount; ++i) {
            ILogicalTable cell = (ILogicalTable)potentialForeignKeysRow.getColumn(i);
            String value = cell.getSource().getCell(0, 0).getStringValue();
            if (value == null || value.trim().length() == 0) continue;
            return value.charAt(0) == '>';
        }
        return false;
    }

    public static ILogicalTable getTableBody(TableSyntaxNode tsn) {
        int startRow = 0;
        startRow = !tsn.hasPropertiesDefinedInTable() ? 1 : 2;
        return (ILogicalTable)tsn.getTable().getRows(startRow);
    }

    public static boolean isHorizontalTable(ILogicalTable dataTableBody, IOpenClass tableType) {
        if (dataTableBody.getHeight() != 1) {
            int fieldsCount2;
            int fieldsCount1 = DataTableBindHelper.countFields(dataTableBody, tableType);
            return fieldsCount1 >= (fieldsCount2 = DataTableBindHelper.countFields((ILogicalTable)dataTableBody.transpose(), tableType));
        }
        return false;
    }

    private static int countFields(ILogicalTable dataTable, IOpenClass tableType) {
        int count = 0;
        int width = dataTable.getWidth();
        for (int i = 0; i < width; ++i) {
            IOpenField field;
            String fieldName = ((ILogicalTable)dataTable.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (fieldName == null || (field = DataTableBindHelper.findField(fieldName = StringUtils.trim((String)fieldName), null, tableType)) == null) continue;
            ++count;
        }
        return count;
    }

    public static IOpenField findField(String fieldName, ITable table, IOpenClass tableType) {
        if (FPK.equals(fieldName)) {
            return new PrimaryKeyField(FPK, table);
        }
        return tableType.getField(fieldName, true);
    }

    public static ILogicalTable getHorizontalTable(ILogicalTable tableBody, IOpenClass tableType) {
        ILogicalTable resultTable = null;
        if (tableBody != null) {
            resultTable = DataTableBindHelper.isHorizontalTable(tableBody, tableType) ? tableBody : (ILogicalTable)tableBody.transpose();
        }
        return resultTable;
    }

    public static ILogicalTable getHorizontalDataWithTitle(ILogicalTable horizDataTableBody) {
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(startIndex);
    }

    public static ILogicalTable getSubTableForBusinessView(ILogicalTable tableBody, IOpenClass tableType) {
        if (DataTableBindHelper.isHorizontalTable(tableBody, tableType)) {
            return DataTableBindHelper.getHorizontalDataWithTitle(tableBody);
        }
        return DataTableBindHelper.getVerticalDataWithTitle(tableBody);
    }

    private static ILogicalTable getVerticalDataWithTitle(ILogicalTable verticalTableBody) {
        ILogicalTable horizDataTableBody = (ILogicalTable)verticalTableBody.transpose();
        int startIndex = DataTableBindHelper.getStartIndexForDataWithTitlesSection(horizDataTableBody);
        return (ILogicalTable)verticalTableBody.getColumns(startIndex);
    }

    private static int getStartIndexForDataWithTitlesSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 2;
        }
        return 1;
    }

    public static ILogicalTable getDescriptorRows(ILogicalTable horizDataTableBody) {
        int endRow = DataTableBindHelper.getEndRowForDescriptorSection(horizDataTableBody);
        return (ILogicalTable)horizDataTableBody.getRows(0, endRow);
    }

    private static int getEndRowForDescriptorSection(ILogicalTable horizDataTableBody) {
        boolean hasForeignKeysRow = DataTableBindHelper.hasForeignKeysRow(horizDataTableBody);
        if (hasForeignKeysRow) {
            return 1;
        }
        return 0;
    }

    public static StringValue makeColumnTitle(IBindingContext bindingContext, ILogicalTable dataWithTitleRows, int column, boolean hasColumnTitleRow) {
        String value = "";
        if (hasColumnTitleRow) {
            ILogicalTable titleCell = (ILogicalTable)dataWithTitleRows.getSubtable(column, 0, 1, 1);
            value = titleCell.getSource().getCell(0, 0).getStringValue();
            value = StringUtils.trimToEmpty((String)value);
            return new StringValue(value, value, value, (IOpenSourceCodeModule)new GridCellSourceCodeModule(titleCell.getSource(), bindingContext));
        }
        return new StringValue(value, value, value, null);
    }

    public static ColumnDescriptor[] makeDescriptors(IBindingContext bindingContext, ITable table, IOpenClass type, OpenL openl, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows, boolean hasForeignKeysRow, boolean hasColumnTytleRow) throws Exception {
        int width = descriptorRows.getWidth();
        ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[width];
        ArrayList<IdentifierNode[]> identifiers = new ArrayList<IdentifierNode[]>(width);
        for (int columnNum = 0; columnNum < width; ++columnNum) {
            ColumnDescriptor currentColumnDescriptor;
            GridCellSourceCodeModule cellSourceModule = DataTableBindHelper.getCellSourceModule(bindingContext, descriptorRows, columnNum);
            String code = cellSourceModule.getCode();
            if (code.length() == 0) continue;
            IdentifierNode[] fieldAccessorChainTokens = Tokenizer.tokenize((IOpenSourceCodeModule)cellSourceModule, (String)CODE_DELIMETERS);
            if (DataTableBindHelper.contains(identifiers, fieldAccessorChainTokens)) {
                String message = String.format("Found duplicate of field \"%s\"", code);
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)cellSourceModule);
                DataTableBindHelper.processError(table, error);
            } else {
                identifiers.add(fieldAccessorChainTokens);
            }
            IOpenField descriptorField = null;
            boolean constructorField = false;
            if (fieldAccessorChainTokens.length == 1) {
                IdentifierNode fieldNameNode = fieldAccessorChainTokens[0];
                if (CONSTRUCTOR_FIELD.equals(fieldNameNode.getIdentifier())) {
                    constructorField = true;
                } else {
                    descriptorField = DataTableBindHelper.getWritableField(fieldNameNode, table, type);
                }
            } else {
                descriptorField = DataTableBindHelper.processFieldsChain(table, type, fieldAccessorChainTokens);
            }
            IdentifierNode foreignKeyTable = null;
            IdentifierNode foreignKey = null;
            if (hasForeignKeysRow) {
                IdentifierNode[] foreignKeyTokens = DataTableBindHelper.getForeignKeyTokens(bindingContext, descriptorRows, columnNum);
                foreignKeyTable = foreignKeyTokens.length > 0 ? foreignKeyTokens[0] : null;
                foreignKey = foreignKeyTokens.length > 1 ? foreignKeyTokens[1] : null;
            }
            StringValue header = DataTableBindHelper.makeColumnTitle(bindingContext, dataWithTitleRows, columnNum, hasColumnTytleRow);
            columnDescriptors[columnNum] = currentColumnDescriptor = DataTableBindHelper.getColumnDescriptor(openl, descriptorField, constructorField, foreignKeyTable, foreignKey, header);
        }
        return columnDescriptors;
    }

    private static GridCellSourceCodeModule getCellSourceModule(IBindingContext bindingContext, ILogicalTable descriptorRows, int columnNum) {
        IGridTable gridTable = ((ILogicalTable)descriptorRows.getColumn(columnNum)).getSource();
        GridCellSourceCodeModule cellSourceModule = new GridCellSourceCodeModule(gridTable, bindingContext);
        return cellSourceModule;
    }

    private static ColumnDescriptor getColumnDescriptor(OpenL openl, IOpenField descriptorField, boolean constructorField, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, StringValue header) {
        ColumnDescriptor currentColumnDescriptor = foreignKeyTable != null ? new ForeignKeyColumnDescriptor(descriptorField, foreignKeyTable, foreignKey, header, openl, constructorField) : new ColumnDescriptor(descriptorField, header, openl, constructorField);
        return currentColumnDescriptor;
    }

    private static IOpenField processFieldsChain(ITable table, IOpenClass type, IdentifierNode[] fieldAccessorChainTokens) {
        IdentifierNode fieldNameNode;
        IOpenField fieldInChain;
        FieldChain chainField = null;
        IOpenClass loadedFieldType = type;
        IOpenField[] fieldAccessorChain = new IOpenField[fieldAccessorChainTokens.length];
        for (int fieldIndex = 0; fieldIndex < fieldAccessorChain.length && (fieldInChain = DataTableBindHelper.getWritableField(fieldNameNode = fieldAccessorChainTokens[fieldIndex], table, loadedFieldType)) != null; ++fieldIndex) {
            loadedFieldType = fieldInChain.getType();
            fieldAccessorChain[fieldIndex] = fieldInChain;
        }
        if (!ArrayTool.contains((Object)fieldAccessorChain, null)) {
            chainField = new FieldChain(type, fieldAccessorChain);
        }
        return chainField;
    }

    private static void processError(ITable table, SyntaxNodeException error) {
        if (table.getTableSyntaxNode() != null) {
            table.getTableSyntaxNode().addError(error);
        }
        BindHelper.processError((SyntaxNodeException)error);
    }

    private static IdentifierNode[] getForeignKeyTokens(IBindingContext bindingContext, ILogicalTable descriptorRows, int columnNum) throws OpenLCompilationException {
        ILogicalTable logicalRegion = (ILogicalTable)descriptorRows.getSubtable(columnNum, 1, 1, 1);
        GridCellSourceCodeModule indexRowSourceModule = new GridCellSourceCodeModule(logicalRegion.getSource(), bindingContext);
        return Tokenizer.tokenize((IOpenSourceCodeModule)indexRowSourceModule, (String)INDEX_ROW_REFERENCE_DELIMITER);
    }

    private static IOpenField getWritableField(IdentifierNode currentFieldNameNode, ITable table, IOpenClass loadedFieldType) {
        String fieldName = currentFieldNameNode.getIdentifier();
        IOpenField field = DataTableBindHelper.findField(fieldName, table, loadedFieldType);
        if (field == null) {
            String errorMessage = String.format("Field \"%s\" not found in %s", fieldName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        if (!field.isWritable()) {
            String message = String.format("Field '%s' is not writable in %s", fieldName, loadedFieldType.getName());
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)currentFieldNameNode);
            DataTableBindHelper.processError(table, error);
            return null;
        }
        return field;
    }

    private static boolean contains(List<IdentifierNode[]> identifiers, IdentifierNode[] identifier) {
        for (IdentifierNode[] existIdentifier : identifiers) {
            if (!DataTableBindHelper.isEqualsIdentifier(existIdentifier, identifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualsIdentifier(IdentifierNode[] identifier1, IdentifierNode[] identifier2) {
        if (identifier1 == null || identifier2 == null) {
            return false;
        }
        if (identifier1.length != identifier2.length) {
            return false;
        }
        for (int i = 0; i < identifier1.length; ++i) {
            if (identifier1[i].getIdentifier().equals(identifier2[i].getIdentifier())) continue;
            return false;
        }
        return true;
    }
}

