/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.AOpenField;
import org.openl.vm.IRuntimeEnv;

class FieldChain
extends AOpenField {
    private IOpenField[] fields;

    public FieldChain(IOpenClass type, IOpenField[] fields) {
        super(FieldChain.makeNames(fields), type);
        this.fields = fields;
    }

    private static String makeNames(IOpenField[] fields) {
        String name = fields[0].getName();
        for (int i = 1; i < fields.length; ++i) {
            name = name + "." + fields[i].getName();
        }
        return name;
    }

    public IOpenClass getDeclaringClass() {
        return this.fields[0].getDeclaringClass();
    }

    public IOpenClass getType() {
        return this.fields[this.fields.length - 1].getType();
    }

    public Object get(Object target, IRuntimeEnv env) {
        Object result = null;
        for (int i = 0; i < this.fields.length; ++i) {
            target = result = this.fields[i].get(target, env);
        }
        return result;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        for (int i = 0; i < this.fields.length - 1; ++i) {
            Object newTarget = this.fields[i].get(target, env);
            if (newTarget == null) {
                newTarget = this.fields[i].getType().newInstance(env);
                this.fields[i].set(target, newTarget, env);
            }
            target = newTarget;
        }
        this.fields[this.fields.length - 1].set(target, value, env);
    }
}

