/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.meta.StringValue;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyColumnDescriptor
extends ColumnDescriptor {
    private static final String NOT_INITIALIZED = "<not_initialized>";
    private IdentifierNode foreignKeyTable;
    private IdentifierNode foreignKey;

    public ForeignKeyColumnDescriptor(IOpenField field, IdentifierNode foreignKeyTable, IdentifierNode foreignKey, StringValue displayValue, OpenL openl, boolean constructor) {
        super(field, displayValue, openl, constructor);
        this.foreignKeyTable = foreignKeyTable;
        this.foreignKey = foreignKey;
    }

    private String getCellStringValue(ILogicalTable cellTable) {
        String value = cellTable.getSource().getCell(0, 0).getStringValue();
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private ArrayList<Object> getArrayValuesByForeignKey(ILogicalTable valuesTable, IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, DomainOpenClass domainClass) throws SyntaxNodeException {
        ArrayList<Object> values;
        block4: {
            boolean multiValue;
            int valuesHeight;
            block3: {
                valuesHeight = valuesTable.getHeight();
                values = new ArrayList<Object>(valuesHeight);
                multiValue = false;
                if (valuesHeight != 1 || !RuleRowHelper.isCommaSeparatedArray(valuesTable)) break block3;
                multiValue = true;
                RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, multiValue);
                String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(valuesTable);
                if (tokens == null) break block4;
                for (String token : tokens) {
                    Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, valuesTable, token);
                    values.add(res);
                }
                break block4;
            }
            for (int i = 0; i < valuesHeight; ++i) {
                ILogicalTable valueTable = (ILogicalTable)valuesTable.getRow(i);
                String value = this.getCellStringValue(valueTable);
                if (value == null || value.length() == 0) {
                    RuleRowHelper.setCellMetaInfo(valueTable, this.getField().getName(), (IOpenClass)domainClass, multiValue);
                    values.add(null);
                    continue;
                }
                RuleRowHelper.setCellMetaInfo(valueTable, this.getField().getName(), (IOpenClass)domainClass, multiValue);
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, valueTable, value);
                values.add(res);
            }
        }
        return values;
    }

    private Object getValueByForeignKeyIndex(IBindingContext bindingContext, ITable foreignTable, int foreignKeyIndex, ILogicalTable valueTable, String key) throws SyntaxNodeException {
        Object result = null;
        try {
            result = foreignTable.findObject(foreignKeyIndex, key, bindingContext);
        }
        catch (SyntaxNodeException ex) {
            this.throwIndexNotFound(valueTable, key, (Exception)((Object)ex), bindingContext);
        }
        if (result == null) {
            this.throwIndexNotFound(valueTable, key, null, bindingContext);
        }
        return result;
    }

    private void throwIndexNotFound(ILogicalTable valuesTable, String src, Exception ex, IBindingContext bindingContext) throws SyntaxNodeException {
        String message = String.format("Index Key %s not found", src);
        throw SyntaxNodeExceptionUtils.createError((String)message, (Throwable)ex, null, (IOpenSourceCodeModule)new GridCellSourceCodeModule(valuesTable.getSource(), bindingContext));
    }

    public Object getLiteralByForeignKey(IOpenClass fieldType, ILogicalTable valuesTable, IDataBase db, IBindingContext bindingContext) throws Exception {
        String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
        ITable foreignTable = db.getTable(foreignKeyTableName);
        Object result = null;
        if (foreignTable == null) {
            String message = String.format("Table '%s' not found", foreignKeyTableName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
        }
        if (foreignTable.getTableSyntaxNode().hasErrors()) {
            String message = String.format("Foreign table '%s' has errors", foreignKeyTableName);
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
        }
        int foreignKeyIndex = 0;
        String columnName = NOT_INITIALIZED;
        if (this.foreignKey != null) {
            columnName = this.foreignKey.getIdentifier();
            foreignKeyIndex = foreignTable.getColumnIndex(columnName);
        }
        if (foreignKeyIndex == -1) {
            String message = "Column " + columnName + " not found";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKey);
        }
        boolean valuesAnArray = ForeignKeyColumnDescriptor.isValuesAnArray(fieldType);
        if (!valuesAnArray) {
            String value = this.getCellStringValue(valuesTable);
            if (value != null && value.length() > 0) {
                result = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, valuesTable, value);
            }
        } else {
            ILogicalTable valueTable;
            String value;
            ArrayList<Object> values = new ArrayList<Object>();
            int valuesHeight = valuesTable.getHeight();
            for (int i = 0; i < valuesHeight && (value = this.getCellStringValue(valueTable = (ILogicalTable)valuesTable.getRow(i))) != null && value.length() != 0; ++i) {
                Object res = this.getValueByForeignKeyIndex(bindingContext, foreignTable, foreignKeyIndex, valueTable, value);
                values.add(res);
            }
            IOpenClass componentType = fieldType.getAggregateInfo().getComponentType(fieldType);
            Object ary = fieldType.getAggregateInfo().makeIndexedAggregate(componentType, new int[]{values.size()});
            for (int i = 0; i < values.size(); ++i) {
                Array.set(ary, i, values.get(i));
            }
            result = ary;
        }
        return result;
    }

    @Override
    public boolean isReference() {
        return this.foreignKeyTable != null;
    }

    public void populateLiteralByForeignKey(Object target, ILogicalTable valuesTable, IDataBase db, IBindingContext cxt) throws Exception {
        if (this.getField() != null && this.foreignKeyTable != null) {
            String foreignKeyTableName = this.foreignKeyTable.getIdentifier();
            ITable foreignTable = db.getTable(foreignKeyTableName);
            if (foreignTable == null) {
                String message = String.format("Table '%s' not found", foreignKeyTableName);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            if (foreignTable.getTableSyntaxNode().hasErrors()) {
                String message = String.format("Foreign table '%s' has errors", foreignKeyTableName);
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKeyTable);
            }
            int foreignKeyIndex = 0;
            String columnName = NOT_INITIALIZED;
            if (this.foreignKey != null) {
                columnName = this.foreignKey.getIdentifier();
                foreignKeyIndex = foreignTable.getColumnIndex(columnName);
            }
            if (foreignKeyIndex == -1) {
                String message = "Column " + columnName + " not found";
                throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)this.foreignKey);
            }
            Map<String, Integer> index = foreignTable.getUniqueIndex(foreignKeyIndex);
            Object[] domainStrings = index.keySet().toArray(new String[0]);
            EnumDomain domain = new EnumDomain(domainStrings);
            DomainOpenClass domainClass = new DomainOpenClass(this.getField().getName(), (IOpenClass)JavaOpenClass.STRING, (IDomain)domain, null);
            valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
            IOpenClass fieldType = this.getField().getType();
            boolean valueAnArray = ForeignKeyColumnDescriptor.isValuesAnArray(fieldType);
            boolean isList = List.class.isAssignableFrom(fieldType.getInstanceClass());
            if (!valueAnArray && !isList) {
                String s = this.getCellStringValue(valuesTable);
                if (s == null || s.length() == 0) {
                    RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, false);
                } else if (s.length() > 0) {
                    RuleRowHelper.setCellMetaInfo(valuesTable, this.getField().getName(), (IOpenClass)domainClass, false);
                    Object res = this.getValueByForeignKeyIndex(cxt, foreignTable, foreignKeyIndex, valuesTable, s);
                    this.getField().set(target, res, this.getRuntimeEnv());
                }
            } else {
                ArrayList<Object> cellValues = this.getArrayValuesByForeignKey(valuesTable, cxt, foreignTable, foreignKeyIndex, domainClass);
                ArrayList values = new ArrayList();
                Predicate predicate = new Predicate(){

                    public boolean evaluate(Object arg) {
                        return arg != null;
                    }
                };
                CollectionUtils.select(cellValues, (Predicate)predicate, values);
                int size = values.size();
                Object componentType = null;
                componentType = valueAnArray ? fieldType.getAggregateInfo().getComponentType(fieldType) : JavaOpenClass.OBJECT;
                Object array = fieldType.getAggregateInfo().makeIndexedAggregate((IOpenClass)componentType, new int[]{size});
                for (int i = 0; i < size; ++i) {
                    Array.set(array, i, values.get(i));
                }
                if (isList) {
                    int len = Array.getLength(array);
                    ArrayList<Object> list = new ArrayList<Object>(len);
                    for (int i = 0; i < len; ++i) {
                        list.add(Array.get(array, i));
                    }
                    this.getField().set(target, list, this.getRuntimeEnv());
                } else {
                    this.getField().set(target, array, this.getRuntimeEnv());
                }
            }
        }
    }
}

