/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.data.ITableModel;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.util.BiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements ITable {
    private ILogicalTable logicalTable;
    private ITableModel dataModel;
    private String tableName;
    private TableSyntaxNode tableSyntaxNode;
    private Object dataArray;
    private BiMap<Integer, Object> rowIndexMap = new BiMap();
    private BiMap<Integer, String> primaryIndexMap = new BiMap();

    public Table(ITableModel dataModel, ILogicalTable data) {
        this.dataModel = dataModel;
        this.logicalTable = data;
    }

    public Table(String tableName, TableSyntaxNode tsn) {
        this.tableName = tableName;
        this.tableSyntaxNode = tsn;
    }

    @Override
    public void setData(ILogicalTable dataWithHeader) {
        this.logicalTable = dataWithHeader;
    }

    @Override
    public void setModel(ITableModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public String getColumnDisplay(int n) {
        return this.dataModel.getDescriptor()[n].getDisplayName();
    }

    @Override
    public int getColumnIndex(String columnName) {
        ColumnDescriptor[] descriptors = this.dataModel.getDescriptor();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] == null || !descriptors[i].getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnName(int n) {
        return this.dataModel.getDescriptor()[n].getName();
    }

    @Override
    public IOpenClass getColumnType(int n) {
        ColumnDescriptor descriptor = this.dataModel.getDescriptor()[n];
        if (!descriptor.isConstructor()) {
            return descriptor.getType();
        }
        return null;
    }

    @Override
    public Object getData(int row) {
        return Array.get(this.dataArray, row);
    }

    @Override
    public Object getDataArray() {
        return this.dataArray;
    }

    @Override
    public ITableModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public IGridTable getHeaderTable() {
        return ((ILogicalTable)this.logicalTable.getRow(0)).getSource();
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public int getNumberOfColumns() {
        return this.dataModel.getDescriptor().length;
    }

    @Override
    public int getNumberOfRows() {
        return this.logicalTable.getHeight() - 1;
    }

    @Override
    public String getPrimaryIndexKey(int row) {
        return (String)this.primaryIndexMap.get((Object)row);
    }

    @Override
    public int getRowIndex(Object target) {
        return (Integer)this.rowIndexMap.getKey(target);
    }

    @Override
    public IGridTable getRowTable(int row) {
        return ((ILogicalTable)this.logicalTable.getRow(row + 1)).getSource();
    }

    @Override
    public int getSize() {
        return Array.getLength(this.dataArray);
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    @Override
    public Map<String, Integer> getUniqueIndex(int columnIndex) throws SyntaxNodeException {
        ColumnDescriptor descriptor = this.dataModel.getDescriptor()[columnIndex];
        return descriptor.getUniqueIndex(this, columnIndex);
    }

    @Override
    public Object getValue(int col, int row) {
        Object rowObject = Array.get(this.getDataArray(), row);
        Object colObject = this.dataModel.getDescriptor()[col].getColumnValue(rowObject);
        return colObject;
    }

    @Override
    public Map<String, Integer> makeUniqueIndex(int colIdx) throws SyntaxNodeException {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        int rows = this.logicalTable.getHeight();
        for (int i = 1; i < rows; ++i) {
            IGridTable gridTable = ((ILogicalTable)this.logicalTable.getSubtable(colIdx, i, 1, 1)).getSource();
            String key = gridTable.getCell(0, 0).getStringValue();
            if (key == null) {
                throw SyntaxNodeExceptionUtils.createError((String)"Empty key in an unique index", (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
            }
            if (index.containsKey(key = key.trim())) {
                throw SyntaxNodeExceptionUtils.createError((String)("Duplicated key in an unique index: " + key), (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
            }
            index.put(key, i - 1);
        }
        return index;
    }

    @Override
    public void populate(IDataBase dataBase, IBindingContext bindingContext) throws Exception {
        int startRow;
        int rows = this.logicalTable.getHeight();
        int columns = this.logicalTable.getWidth();
        for (int i = startRow = 1; i < rows; ++i) {
            Object target = Array.get(this.dataArray, i - startRow);
            for (int j = 0; j < columns; ++j) {
                ForeignKeyColumnDescriptor fkDescriptor;
                ColumnDescriptor descriptor = this.dataModel.getDescriptor()[j];
                if (descriptor == null || !(descriptor instanceof ForeignKeyColumnDescriptor) || !(fkDescriptor = (ForeignKeyColumnDescriptor)descriptor).isReference()) continue;
                if (descriptor.isConstructor()) {
                    target = fkDescriptor.getLiteralByForeignKey(this.dataModel.getType(), (ILogicalTable)this.logicalTable.getSubtable(j, i, 1, 1), dataBase, bindingContext);
                    continue;
                }
                fkDescriptor.populateLiteralByForeignKey(target, (ILogicalTable)this.logicalTable.getSubtable(j, i, 1, 1), dataBase, bindingContext);
            }
        }
    }

    @Override
    public void preLoad(OpenlToolAdaptor openlAdapter) throws Exception {
        int rows = this.logicalTable.getHeight();
        int startRow = this.getStartRowForData();
        this.dataArray = Array.newInstance(this.dataModel.getInstanceClass(), rows - startRow);
        for (int rowNum = startRow; rowNum < rows; ++rowNum) {
            this.processRow(openlAdapter, startRow, rowNum);
        }
    }

    private void processRow(OpenlToolAdaptor openlAdapter, int startRow, int rowNum) throws OpenLCompilationException {
        boolean constructor = this.isConstructor();
        Object literal = null;
        int rowIndex = rowNum - startRow;
        if (!constructor) {
            literal = this.dataModel.newInstance();
            if (literal == null) {
                String errorMessage = String.format("Can`t create instance of %s", this.dataModel.getName());
                throw new OpenLCompilationException(errorMessage);
            }
            this.addToRowIndex(rowIndex, literal);
        }
        int columns = this.logicalTable.getWidth();
        for (int columnNum = 0; columnNum < columns; ++columnNum) {
            literal = this.processColumn(openlAdapter, constructor, rowNum, literal, columnNum);
        }
        if (literal == null) {
            literal = this.dataModel.getType().nullObject();
        }
        Array.set(this.dataArray, rowNum - startRow, literal);
    }

    private Object processColumn(OpenlToolAdaptor openlAdapter, boolean constructor, int rowNum, Object literal, int columnNum) throws SyntaxNodeException {
        ColumnDescriptor columnDescriptor = this.dataModel.getDescriptor()[columnNum];
        if (columnDescriptor != null && !columnDescriptor.isReference()) {
            if (constructor) {
                literal = columnDescriptor.getLiteral(this.dataModel.getType(), (ILogicalTable)this.logicalTable.getSubtable(columnNum, rowNum, 1, 1), openlAdapter);
            } else {
                try {
                    columnDescriptor.populateLiteral(literal, (ILogicalTable)this.logicalTable.getSubtable(columnNum, rowNum, 1, 1), openlAdapter);
                }
                catch (SyntaxNodeException ex) {
                    this.tableSyntaxNode.addError(ex);
                    BindHelper.processError((SyntaxNodeException)ex);
                }
            }
        }
        return literal;
    }

    @Override
    public synchronized void setPrimaryIndexKey(int row, String value) {
        Integer oldRow = (Integer)this.primaryIndexMap.getKey((Object)value);
        if (oldRow != null) {
            throw new OpenLRuntimeException("Duplicated key: " + value + "in rows " + oldRow + "," + row);
        }
        this.primaryIndexMap.put((Object)row, (Object)value);
    }

    @Override
    public Object findObject(int columnIndex, String skey, IBindingContext cxt) throws SyntaxNodeException {
        Map<String, Integer> index = this.getUniqueIndex(columnIndex);
        Integer found = index.get(skey);
        if (found == null) {
            return null;
        }
        return Array.get(this.dataArray, found);
    }

    private void addToRowIndex(int rowIndex, Object target) {
        this.rowIndexMap.put((Object)rowIndex, target);
    }

    private int getStartRowForData() {
        if (this.dataModel.hasColumnTitleRow()) {
            return 1;
        }
        return 0;
    }

    private boolean isConstructor() {
        for (int i = 0; i < this.dataModel.getDescriptor().length; ++i) {
            ColumnDescriptor columnDescriptor = this.dataModel.getDescriptor()[i];
            if (columnDescriptor == null || !columnDescriptor.isConstructor()) continue;
            return true;
        }
        return false;
    }
}

