/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.BindHelper;
import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.datatype.binding.DatatypeNodeLevelComparator;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.util.ArrayTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeHelper {
    public static IDomain<?> getTypeDomain(ILogicalTable table, IOpenClass type, OpenL openl, IBindingContext cxt) throws SyntaxNodeException {
        Object values;
        if (table != null && (values = DatatypeHelper.loadAliasDatatypeValues(table, type, openl, cxt)) != null) {
            return new EnumDomain(ArrayTool.toArray((Object)values));
        }
        return new EnumDomain(new Object[0]);
    }

    public static Object loadAliasDatatypeValues(ILogicalTable table, IOpenClass type, OpenL openl, IBindingContext cxt) throws SyntaxNodeException {
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, cxt);
        return RuleRowHelper.loadParam(table, type, "Values", "", openlAdaptor, true);
    }

    public static ILogicalTable getNormalizedDataPartTable(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int horizontalCount;
        ILogicalTable dataPart = null;
        dataPart = PropertiesHelper.getPropertiesTableSection(table) != null ? (ILogicalTable)table.getRows(2) : (ILogicalTable)table.getRows(1);
        if (dataPart == null) {
            return null;
        }
        if (dataPart.getHeight() == 1) {
            return dataPart;
        }
        if (dataPart.getWidth() == 1) {
            return (ILogicalTable)dataPart.transpose();
        }
        int verticalCount = DatatypeHelper.countTypes(dataPart, openl, cxt);
        if (verticalCount < (horizontalCount = DatatypeHelper.countTypes((ILogicalTable)dataPart.transpose(), openl, cxt))) {
            return (ILogicalTable)dataPart.transpose();
        }
        return dataPart;
    }

    private static int countTypes(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        int height = table.getHeight();
        int count = 0;
        for (int i = 0; i < height; ++i) {
            try {
                IOpenClass type = DatatypeHelper.makeType((ILogicalTable)table.getRow(i), openl, cxt);
                if (type == null) continue;
                ++count;
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return count;
    }

    private static IOpenClass makeType(ILogicalTable table, OpenL openl, IBindingContext cxt) {
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), cxt);
        return OpenLManager.makeType((OpenL)openl, (IOpenSourceCodeModule)source, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
    }

    private static String getDatatypeName(TableSyntaxNode tsn) throws OpenLCompilationException {
        if (XlsNodeTypes.XLS_DATATYPE.toString().equals(tsn.getType())) {
            IOpenSourceCodeModule src = tsn.getHeader().getModule();
            IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
            return parsedHeader[1].getIdentifier();
        }
        return null;
    }

    private static String getParentDatatypeName(TableSyntaxNode tsn) throws OpenLCompilationException {
        if (XlsNodeTypes.XLS_DATATYPE.toString().equals(tsn.getType())) {
            IOpenSourceCodeModule src = tsn.getHeader().getModule();
            IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)src, (String)" \n\r");
            if (parsedHeader.length == 4) {
                return parsedHeader[3].getIdentifier();
            }
            return null;
        }
        return null;
    }

    public static Map<String, TableSyntaxNode> createTypesMap(TableSyntaxNode[] nodes, IBindingContext bindingContext) {
        HashMap<String, TableSyntaxNode> map = new HashMap<String, TableSyntaxNode>();
        if (nodes == null) {
            return map;
        }
        for (TableSyntaxNode tsn : nodes) {
            SyntaxNodeException error;
            String message;
            if (!XlsNodeTypes.XLS_DATATYPE.toString().equals(tsn.getType())) continue;
            try {
                String datatypeName = DatatypeHelper.getDatatypeName(tsn);
                if (datatypeName != null) {
                    if (map.containsKey(datatypeName)) {
                        message = String.format("Type with name '%s' already exists", datatypeName);
                        error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tsn);
                        tsn.addError(error);
                        BindHelper.processError((SyntaxNodeException)error);
                        continue;
                    }
                    map.put(datatypeName, tsn);
                    continue;
                }
                message = "Cannot recognize type name";
                error = SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tsn);
                tsn.addError(error);
                BindHelper.processError((SyntaxNodeException)error);
            }
            catch (OpenLCompilationException e) {
                message = "An error has occurred during compilation";
                error = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)tsn);
                tsn.addError(error);
                BindHelper.processError((SyntaxNodeException)error);
            }
        }
        return map;
    }

    public static TableSyntaxNode[] orderDatatypes(Map<String, TableSyntaxNode> typesMap, IBindingContext bindingContext) {
        HashMap<TableSyntaxNode, Integer> levelsMap = new HashMap<TableSyntaxNode, Integer>();
        for (TableSyntaxNode node : typesMap.values()) {
            try {
                int level = DatatypeHelper.getInheritanceLevel(typesMap, node);
                levelsMap.put(node, level);
            }
            catch (OpenLCompilationException e) {
                String message = "An error has occurred during compilation";
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)node);
                node.addError(error);
                BindHelper.processError((SyntaxNodeException)error);
            }
        }
        Set nodes = levelsMap.keySet();
        TableSyntaxNode[] nodesToOrder = nodes.toArray(new TableSyntaxNode[nodes.size()]);
        DatatypeNodeLevelComparator comparator = new DatatypeNodeLevelComparator(levelsMap);
        Arrays.sort(nodesToOrder, comparator);
        return nodesToOrder;
    }

    public static int getInheritanceLevel(Map<String, TableSyntaxNode> types, TableSyntaxNode tsn) throws OpenLCompilationException {
        return DatatypeHelper.getInheritanceLevel(types, tsn, new LinkedHashMap<String, TableSyntaxNode>());
    }

    private static int getInheritanceLevel(Map<String, TableSyntaxNode> types, TableSyntaxNode tsn, Map<String, TableSyntaxNode> children) throws OpenLCompilationException {
        String parent = DatatypeHelper.getParentDatatypeName(tsn);
        if (parent != null && types.containsKey(parent)) {
            if (children.containsKey(parent)) {
                Set<String> keys = children.keySet();
                String typesCycle = StringUtils.join(keys, (String)" -> ");
                throw new OpenLCompilationException(String.format("Invalid type hierarchy found: %s", typesCycle));
            }
            children.put(parent, tsn);
            return 1 + DatatypeHelper.getInheritanceLevel(types, types.get(parent), children);
        }
        return 0;
    }
}

