/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IMemberBoundNode;
import org.openl.domain.IDomain;
import org.openl.engine.OpenLManager;
import org.openl.rules.datatype.binding.AliasDatatypeBoundNode;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.DatatypeTableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;

public class DatatypeNodeBinder
extends AXlsTableBinder {
    public static final int PARENT_TYPE_INDEX = 3;
    public static final int TYPE_INDEX = 1;

    public IMemberBoundNode preBind(TableSyntaxNode tsn, OpenL openl, IBindingContext cxt, XlsModuleOpenClass module) throws Exception {
        ILogicalTable table = tsn.getTable();
        GridCellSourceCodeModule tableSource = new GridCellSourceCodeModule(table.getSource(), cxt);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)tableSource, (String)" \n\r");
        if (parsedHeader.length < 2) {
            String message = "Datatype table format: Datatype <typename>";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)tableSource);
        }
        String typeName = parsedHeader[1].getIdentifier();
        if (cxt.findType("org.openl.this", typeName) != null) {
            String message = "Duplicate type definition: " + typeName;
            throw SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)parsedHeader[1]);
        }
        this.putSubTableForBussinesView(tsn);
        if (parsedHeader.length == 3 && parsedHeader[2] != null && parsedHeader[2].getIdentifier().startsWith("<") && parsedHeader[2].getIdentifier().endsWith(">")) {
            int beginIndex = 1;
            int endIndex = parsedHeader[2].getIdentifier().length() - 1;
            String type = parsedHeader[2].getIdentifier().substring(beginIndex, endIndex).trim();
            StringSourceCodeModule aliasTypeSource = new StringSourceCodeModule(type, tableSource.getUri(0));
            StringSourceCodeModule arrayAliasTypeSource = new StringSourceCodeModule(type + "[]", tableSource.getUri(0));
            IOpenClass baseOpenClass = OpenLManager.makeType((OpenL)openl, (IOpenSourceCodeModule)aliasTypeSource, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
            IOpenClass arrayOpenClass = OpenLManager.makeType((OpenL)openl, (IOpenSourceCodeModule)arrayAliasTypeSource, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
            ILogicalTable dataPart = DatatypeHelper.getNormalizedDataPartTable(table, openl, cxt);
            IDomain<?> domain = DatatypeHelper.getTypeDomain(dataPart, arrayOpenClass, openl, cxt);
            DomainOpenClass tableType = new DomainOpenClass(typeName, baseOpenClass, domain, null);
            cxt.addType("org.openl.this", (IOpenClass)tableType);
            return new AliasDatatypeBoundNode(tsn, tableType, module, table, openl);
        }
        if (parsedHeader.length != 2 && parsedHeader.length != 4 || parsedHeader.length == 4 && !parsedHeader[2].getIdentifier().equals("extends")) {
            String message = "Datatype table formats: [Datatype %typename%] or [Datatype %typename% extends %parentTypeName%] or [Datatype %typename% %<aliastype>%] ";
            throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)tableSource);
        }
        String packageName = tsn.getTableProperties().getPropertyValueAsString("datatypePackage");
        DatatypeOpenClass tableType = new DatatypeOpenClass(module.getSchema(), typeName, packageName);
        cxt.addType("org.openl.this", (IOpenClass)tableType);
        if (parsedHeader.length == 4) {
            return new DatatypeTableBoundNode(tsn, tableType, module, table, openl, parsedHeader[3].getIdentifier());
        }
        return new DatatypeTableBoundNode(tsn, tableType, module, table, openl);
    }

    private void putSubTableForBussinesView(TableSyntaxNode tsn) {
        tsn.getSubTables().put("view.business", tsn.getTableBody());
    }
}

