/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.datatype.binding.DatatypeHelper;
import org.openl.rules.datatype.binding.FieldType;
import org.openl.rules.datatype.binding.SimpleBeanByteCodeGenerator;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.InternalDatatypeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeTableBoundNode
implements IMemberBoundNode {
    private TableSyntaxNode tableSyntaxNode;
    private DatatypeOpenClass dataType;
    private String parentClassName;
    private ModuleOpenClass moduleOpenClass;
    private ILogicalTable table;
    private OpenL openl;

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl) {
        this(tableSyntaxNode, datatype, moduleOpenClass, table, openl, null);
    }

    public DatatypeTableBoundNode(TableSyntaxNode tableSyntaxNode, DatatypeOpenClass datatype, ModuleOpenClass moduleOpenClass, ILogicalTable table, OpenL openl, String parentClassName) {
        this.tableSyntaxNode = tableSyntaxNode;
        this.dataType = datatype;
        this.table = table;
        this.openl = openl;
        this.parentClassName = parentClassName;
        this.moduleOpenClass = moduleOpenClass;
    }

    private void addFields(IBindingContext cxt) throws Exception {
        ILogicalTable dataTable = DatatypeHelper.getNormalizedDataPartTable(this.table, this.openl, cxt);
        int tableHeight = 0;
        if (dataTable != null) {
            tableHeight = dataTable.getHeight();
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (int i = 0; i < tableHeight; ++i) {
            ILogicalTable row = (ILogicalTable)dataTable.getRow(i);
            boolean firstField = false;
            if (i == 0) {
                firstField = true;
            }
            this.processRow(row, cxt, fields, firstField);
        }
        this.checkInheritedFieldsDuplication(cxt);
        if (this.beanClassCanBeGenerated(cxt)) {
            Class<?> beanClass = this.createBeanForDatatype(fields);
            this.dataType.setInstanceClass(beanClass);
        }
    }

    private boolean beanClassCanBeGenerated(IBindingContext cxt) {
        IOpenClass parentClass;
        if (this.tableSyntaxNode.hasErrors()) {
            return false;
        }
        return this.parentClassName == null || (parentClass = cxt.findType("org.openl.this", this.parentClassName)).getInstanceClass() != null;
    }

    private Class<?> createBeanForDatatype(Map<String, FieldType> fields) throws SyntaxNodeException {
        String datatypeName = this.dataType.getName();
        String beanName = this.getDatatypeBeanNameWithNamespace(datatypeName);
        SimpleBeanByteCodeGenerator beanGenerator = new SimpleBeanByteCodeGenerator(beanName, fields, this.dataType.getSuperClass());
        Class<?> beanClass = beanGenerator.generateAndLoadBeanClass();
        if (beanClass == null) {
            String errorMessage = String.format("Cant generate bean for datatype '%s'", datatypeName);
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, (ISyntaxNode)this.tableSyntaxNode);
        }
        return beanClass;
    }

    private String getDatatypeBeanNameWithNamespace(String datatypeName) {
        return String.format("%s.%s", this.tableSyntaxNode.getTableProperties().getPropertyValue("datatypePackage"), datatypeName);
    }

    private void processRow(ILogicalTable row, IBindingContext cxt, Map<String, FieldType> fields, boolean firstField) throws SyntaxNodeException, OpenLCompilationException {
        GridCellSourceCodeModule rowSrc = new GridCellSourceCodeModule(row.getSource(), cxt);
        if (this.canProcessRow(rowSrc)) {
            GridCellSourceCodeModule firstLogicalRowSrc = new GridCellSourceCodeModule(((ILogicalTable)row.getColumn(1)).getSource(), cxt);
            IdentifierNode[] idn = this.getIdentifierNode(firstLogicalRowSrc);
            String fieldName = idn[0].getIdentifier();
            IOpenClass fieldType = this.getFieldType(cxt, row, rowSrc);
            DatatypeOpenField field = new DatatypeOpenField((IOpenClass)this.dataType, fieldName, fieldType);
            try {
                this.dataType.addField((IOpenField)field);
                fields.put(fieldName, new FieldType((IOpenField)field));
                if (firstField) {
                    this.dataType.setIndexField((IOpenField)field);
                }
            }
            catch (Throwable t) {
                String errorMessage = String.format("Can not add field %s: %s", fieldName, t.getMessage());
                throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)firstLogicalRowSrc);
            }
        }
    }

    private IdentifierNode[] getIdentifierNode(GridCellSourceCodeModule firstLogicalRowSrc) throws OpenLCompilationException, SyntaxNodeException {
        IdentifierNode[] idn = Tokenizer.tokenize((IOpenSourceCodeModule)firstLogicalRowSrc, (String)" \r\n");
        if (idn.length != 1) {
            String errorMessage = String.format("Bad field name: %s", firstLogicalRowSrc.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)firstLogicalRowSrc);
        }
        return idn;
    }

    private boolean canProcessRow(GridCellSourceCodeModule rowSrc) {
        String srcCode = rowSrc.getCode().trim();
        return srcCode.length() != 0 && !srcCode.startsWith("//");
    }

    private IOpenClass getFieldType(IBindingContext cxt, ILogicalTable row, GridCellSourceCodeModule tableSrc) throws SyntaxNodeException {
        IOpenClass fieldType = OpenLManager.makeType((OpenL)this.openl, (IOpenSourceCodeModule)tableSrc, (IBindingContextDelegator)((IBindingContextDelegator)cxt));
        if (fieldType == null || fieldType instanceof NullOpenClass) {
            String errorMessage = String.format("Type %s not found", tableSrc.getCode());
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        if (row.getWidth() < 2) {
            String errorMessage = "Bad table structure: must be {header} / {type | name}";
            throw SyntaxNodeExceptionUtils.createError((String)errorMessage, null, null, (IOpenSourceCodeModule)tableSrc);
        }
        return fieldType;
    }

    public void addTo(ModuleOpenClass openClass) {
        InternalDatatypeClass internalClassMember = new InternalDatatypeClass((IOpenClass)this.dataType, (IOpenClass)openClass);
        this.tableSyntaxNode.setMember((IOpenMember)internalClassMember);
    }

    public void finalizeBind(IBindingContext cxt) throws Exception {
        if (this.parentClassName != null) {
            IOpenClass parentClass = cxt.findType("org.openl.this", this.parentClassName);
            if (parentClass == null) {
                cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                throw new OpenLCompilationException(String.format("Parent class '%s' is not defined", this.parentClassName));
            }
            if (parentClass.getInstanceClass() != null) {
                if (Modifier.isFinal(parentClass.getInstanceClass().getModifiers())) {
                    cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                    throw new OpenLCompilationException(String.format("Cannot inherit from final class \"%s\"", this.parentClassName));
                }
                if (Modifier.isAbstract(parentClass.getInstanceClass().getModifiers())) {
                    cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                    throw new OpenLCompilationException(String.format("Cannot inherit from abstract class \"%s\"", this.parentClassName));
                }
            }
            if (parentClass instanceof DomainOpenClass) {
                cxt.removeType("org.openl.this", (IOpenClass)this.dataType);
                throw new OpenLCompilationException(String.format("Parent class '%s' cannot be domain type", this.parentClassName));
            }
            this.dataType.setSuperClass(parentClass);
        }
        this.addFields(cxt);
        if (this.dataType.getFields().size() > 0) {
            this.dataType.addMethod(new DatatypeOpenClass.OpenFieldsConstructor((IOpenClass)this.dataType));
        }
        this.moduleOpenClass.addType("org.openl.this", (IOpenClass)this.dataType);
    }

    private void checkInheritedFieldsDuplication(IBindingContext cxt) throws Exception {
        IOpenClass superClass = this.dataType.getSuperClass();
        if (superClass != null) {
            for (Map.Entry<String, IOpenField> field : this.dataType.getDeclaredFields().entrySet()) {
                IOpenField fieldInParent = superClass.getField(field.getKey());
                if (fieldInParent == null) continue;
                if (fieldInParent.getType().getInstanceClass().equals(field.getValue().getType().getInstanceClass())) {
                    BindHelper.processWarn((String)String.format("Field [%s] has been already defined in class \"%s\"", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), (ISyntaxNode)this.tableSyntaxNode, (IBindingContext)cxt);
                    continue;
                }
                throw new SyntaxNodeException(String.format("Field [%s] has been already defined in class \"%s\" with another type", field.getKey(), fieldInParent.getDeclaringClass().getDisplayName(0)), null, (ISyntaxNode)this.tableSyntaxNode);
            }
        }
    }
}

