/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import org.apache.commons.lang.StringUtils;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.ArrayOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType {
    private String typeName;
    private Class<?> type;

    public FieldType(String typeName, Class<?> type) {
        this.typeName = typeName;
        this.type = type;
    }

    public FieldType(IOpenField field) {
        this.typeName = this.getTypeName(field);
        this.type = field.getType().getInstanceClass();
    }

    private String getTypeName(IOpenField field) {
        String fieldName = field.getType().getName();
        IOpenClass typeDeclaration = this.getTypeDeclaration(field);
        if (fieldName.indexOf(".") < 0 && typeDeclaration instanceof DatatypeOpenClass) {
            String packageName = ((DatatypeOpenClass)typeDeclaration).getPackageName();
            if (StringUtils.isBlank((String)packageName)) {
                return fieldName;
            }
            return String.format("%s.%s", packageName, fieldName);
        }
        return fieldName;
    }

    private IOpenClass getTypeDeclaration(IOpenField field) {
        IOpenClass fieldType = field.getType();
        IOpenClass typeDeclaration = null;
        typeDeclaration = fieldType.isArray() && fieldType instanceof ArrayOpenClass ? ((ArrayOpenClass)fieldType).getComponentClass() : fieldType;
        return typeDeclaration;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isArray() {
        if (this.type != null && this.type.isArray()) {
            return true;
        }
        return this.typeName.endsWith("]");
    }

    public String toString() {
        if (StringUtils.isNotBlank((String)this.typeName)) {
            return this.typeName;
        }
        return super.toString();
    }
}

