/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.binding;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.cglib.core.ReflectUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openl.binding.MethodUtil;
import org.openl.rules.datatype.binding.FieldType;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.StringTool;
import org.openl.util.generation.JavaClassGeneratorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanByteCodeGenerator {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private final Log LOG = LogFactory.getLog(SimpleBeanByteCodeGenerator.class);
    private String beanName;
    private IOpenClass parentClass;
    private Map<String, FieldType> beanFields;
    private Map<String, FieldType> allFields;
    private int twoStackElementFieldsCount;
    private byte[] generatedByteCode;
    private String beanNameWithPackage;

    public SimpleBeanByteCodeGenerator(String beanName, Map<String, FieldType> beanFields) {
        this(beanName, beanFields, null);
    }

    public SimpleBeanByteCodeGenerator(String beanName, Map<String, FieldType> beanFields, IOpenClass parentClass) {
        this.beanName = beanName;
        this.beanFields = beanFields;
        this.parentClass = parentClass;
        this.allFields = new LinkedHashMap<String, FieldType>();
        if (parentClass != null) {
            this.allFields.putAll(this.convertFields(parentClass.getFields()));
        }
        this.allFields.putAll(beanFields);
        this.twoStackElementFieldsCount = this.getTwoStackElementFieldsCount(this.allFields);
    }

    public byte[] generateClassByteCode() {
        this.beanNameWithPackage = JavaClassGeneratorHelper.replaceCommas((String)this.beanName);
        ClassWriter classWriter = new ClassWriter(false);
        this.writeClassDescription(this.beanNameWithPackage, classWriter);
        this.writeFields(classWriter);
        this.writeDefaultConstructor(classWriter);
        this.writeConstructorWithFields(classWriter);
        this.writeGettersAndSetters(classWriter);
        this.writeToStringMethod(classWriter);
        this.writeEqualsMethod(classWriter);
        this.writeHashCodeMethod(classWriter);
        this.generatedByteCode = classWriter.toByteArray();
        return this.generatedByteCode;
    }

    public Class<?> generateAndLoadBeanClass() {
        if (this.generatedByteCode != null) {
            return this.loadClass(this.generatedByteCode);
        }
        return this.loadClass(this.generateClassByteCode());
    }

    private void writeGettersAndSetters(ClassWriter classWriter) {
        for (Map.Entry<String, FieldType> field : this.beanFields.entrySet()) {
            this.generateGetter(this.beanNameWithPackage, classWriter, field);
            this.generateSetter(this.beanNameWithPackage, classWriter, field);
        }
    }

    private void writeToStringMethod(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "toString", String.format("()%s", this.getJavaType(String.class)), null, null);
        codeVisitor.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        codeVisitor.visitInsn(89);
        codeVisitor.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        codeVisitor.visitVarInsn(25, 0);
        this.invokeVirtual(codeVisitor, Object.class, "getClass", new Class[0]);
        this.invokeVirtual(codeVisitor, Class.class, "getSimpleName", new Class[0]);
        this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{String.class});
        codeVisitor.visitLdcInsn((Object)"{ ");
        this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{String.class});
        for (Map.Entry<String, FieldType> field : this.allFields.entrySet()) {
            codeVisitor.visitLdcInsn((Object)(field.getKey() + "="));
            this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{String.class});
            this.pushFieldToStack(codeVisitor, 0, field.getKey());
            if (field.getValue().isArray()) {
                this.invokeStatic(codeVisitor, ArrayUtils.class, "toString", new Class[]{this.getJavaClass(field.getValue())});
            }
            this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{this.getJavaClass(field.getValue())});
            codeVisitor.visitLdcInsn((Object)" ");
            this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{String.class});
        }
        codeVisitor.visitLdcInsn((Object)"}");
        this.invokeVirtual(codeVisitor, StringBuilder.class, "append", new Class[]{String.class});
        this.invokeVirtual(codeVisitor, StringBuilder.class, "toString", new Class[0]);
        codeVisitor.visitInsn(this.getConstantForReturn(String.class));
        if (this.twoStackElementFieldsCount > 0) {
            codeVisitor.visitMaxs(3, 1);
        } else {
            codeVisitor.visitMaxs(2, 1);
        }
    }

    private void writeEqualsMethod(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "equals", String.format("(%s)%s", this.getJavaType(Object.class), this.getJavaType(Boolean.TYPE)), null, null);
        codeVisitor.visitTypeInsn(187, Type.getInternalName(EqualsBuilder.class));
        codeVisitor.visitInsn(89);
        codeVisitor.visitMethodInsn(183, Type.getInternalName(EqualsBuilder.class), "<init>", "()V");
        Label comparingLabel = new Label();
        codeVisitor.visitVarInsn(25, 1);
        codeVisitor.visitTypeInsn(193, this.beanNameWithPackage);
        codeVisitor.visitJumpInsn(154, comparingLabel);
        codeVisitor.visitLdcInsn((Object)Boolean.FALSE);
        codeVisitor.visitInsn(this.getConstantForReturn(Boolean.TYPE));
        codeVisitor.visitLabel(comparingLabel);
        codeVisitor.visitVarInsn(25, 1);
        codeVisitor.visitTypeInsn(192, this.beanNameWithPackage);
        codeVisitor.visitVarInsn(58, 2);
        for (Map.Entry<String, FieldType> field : this.allFields.entrySet()) {
            this.pushFieldToStack(codeVisitor, 0, field.getKey());
            this.pushFieldToStack(codeVisitor, 2, field.getKey());
            Class<?> fieldType = this.getJavaClass(field.getValue());
            this.invokeVirtual(codeVisitor, EqualsBuilder.class, "append", new Class[]{fieldType, fieldType});
        }
        this.invokeVirtual(codeVisitor, EqualsBuilder.class, "isEquals", new Class[0]);
        codeVisitor.visitInsn(this.getConstantForReturn(Boolean.TYPE));
        if (this.twoStackElementFieldsCount > 0) {
            codeVisitor.visitMaxs(5, 3);
        } else {
            codeVisitor.visitMaxs(3, 3);
        }
    }

    private void writeHashCodeMethod(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "hashCode", String.format("()%s", this.getJavaType(Integer.TYPE)), null, null);
        codeVisitor.visitTypeInsn(187, Type.getInternalName(HashCodeBuilder.class));
        codeVisitor.visitInsn(89);
        codeVisitor.visitMethodInsn(183, Type.getInternalName(HashCodeBuilder.class), "<init>", "()V");
        for (Map.Entry<String, FieldType> field : this.allFields.entrySet()) {
            this.pushFieldToStack(codeVisitor, 0, field.getKey());
            this.invokeVirtual(codeVisitor, HashCodeBuilder.class, "append", new Class[]{this.getJavaClass(field.getValue())});
        }
        this.invokeVirtual(codeVisitor, HashCodeBuilder.class, "toHashCode", new Class[0]);
        codeVisitor.visitInsn(this.getConstantForReturn(Integer.TYPE));
        if (this.twoStackElementFieldsCount > 0) {
            codeVisitor.visitMaxs(3, 1);
        } else {
            codeVisitor.visitMaxs(2, 2);
        }
    }

    private void writeConstructorWithFields(ClassWriter classWriter) {
        FieldType fieldType;
        CodeVisitor codeVisitor;
        Constructor parentConstructorWithFields = null;
        if (this.parentClass != null) {
            parentConstructorWithFields = JavaClassGeneratorHelper.getBeanConstructorWithAllFields((Class)this.parentClass.getInstanceClass(), (int)this.parentClass.getFields().size());
        }
        int i = 1;
        int stackSizeForParentConstructorCall = 0;
        if (parentConstructorWithFields == null) {
            codeVisitor = classWriter.visitMethod(1, "<init>", this.getMethodSignatureForByteCode(this.beanFields, null), null, null);
            codeVisitor.visitVarInsn(25, 0);
            if (this.parentClass == null) {
                codeVisitor.visitMethodInsn(183, JAVA_LANG_OBJECT, "<init>", "()V");
            } else {
                codeVisitor.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass.getInstanceClass()), "<init>", "()V");
            }
        } else {
            codeVisitor = classWriter.visitMethod(1, "<init>", this.getMethodSignatureForByteCode(this.allFields, null), null, null);
            codeVisitor.visitVarInsn(25, 0);
            Map<String, FieldType> parentFields = this.convertFields(this.parentClass.getFields());
            for (Map.Entry<String, FieldType> field : parentFields.entrySet()) {
                fieldType = field.getValue();
                codeVisitor.visitVarInsn(this.getConstantForVarInsn(fieldType), i);
                if (Long.TYPE.equals(fieldType.getType()) || Double.TYPE.equals(fieldType.getType())) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            stackSizeForParentConstructorCall = i;
            codeVisitor.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass.getInstanceClass()), "<init>", this.getMethodSignatureForByteCode(parentFields, null));
        }
        for (Map.Entry<String, FieldType> field : this.beanFields.entrySet()) {
            String fieldName = field.getKey();
            if (this.parentClass != null && this.parentClass.getField(fieldName) != null) continue;
            fieldType = field.getValue();
            codeVisitor.visitVarInsn(25, 0);
            codeVisitor.visitVarInsn(this.getConstantForVarInsn(fieldType), i);
            codeVisitor.visitFieldInsn(181, this.beanNameWithPackage, fieldName, this.getJavaType(fieldType));
            if (Long.TYPE.equals(fieldType.getType()) || Double.TYPE.equals(fieldType.getType())) {
                i += 2;
                continue;
            }
            ++i;
        }
        codeVisitor.visitInsn(177);
        if (this.twoStackElementFieldsCount > 0) {
            codeVisitor.visitMaxs(3 + stackSizeForParentConstructorCall, this.allFields.size() + 1 + this.twoStackElementFieldsCount);
        } else {
            codeVisitor.visitMaxs(2 + stackSizeForParentConstructorCall, this.allFields.size() + 1);
        }
    }

    private void writeDefaultConstructor(ClassWriter classWriter) {
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        codeVisitor.visitVarInsn(25, 0);
        if (this.parentClass == null) {
            codeVisitor.visitMethodInsn(183, JAVA_LANG_OBJECT, "<init>", "()V");
        } else {
            codeVisitor.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass.getInstanceClass()), "<init>", "()V");
        }
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(1, 1);
    }

    private void writeFields(ClassWriter classWriter) {
        for (Map.Entry<String, FieldType> field : this.beanFields.entrySet()) {
            String fieldTypeName = this.getJavaType(field.getValue());
            classWriter.visitField(4, field.getKey(), fieldTypeName, null, null);
        }
    }

    private void writeClassDescription(String beanNameWithPackage, ClassWriter classWriter) {
        String sourceFileName = JavaClassGeneratorHelper.getClassFileName((String)beanNameWithPackage);
        if (this.parentClass == null) {
            classWriter.visit(49, 33, beanNameWithPackage, JAVA_LANG_OBJECT, null, sourceFileName);
        } else {
            classWriter.visit(49, 33, beanNameWithPackage, Type.getInternalName((Class)this.parentClass.getInstanceClass()), null, sourceFileName);
        }
    }

    private void writeBytesToFile(byte[] byteArray) {
        String strFilePath = String.format("D://%s.class", JavaClassGeneratorHelper.getShortClassName((String)this.beanName));
        try {
            FileOutputStream fos = new FileOutputStream(strFilePath);
            fos.write(byteArray);
            fos.close();
        }
        catch (FileNotFoundException ex) {
            this.LOG.error((Object)this, (Throwable)ex);
        }
        catch (IOException ioe) {
            this.LOG.error((Object)this, (Throwable)ioe);
        }
    }

    private void generateGetter(String beanNameWithPackage, ClassWriter classWriter, Map.Entry<String, FieldType> field) {
        String fieldName = field.getKey();
        FieldType fieldType = field.getValue();
        String getterName = StringTool.getGetterName((String)fieldName);
        CodeVisitor codeVisitor = classWriter.visitMethod(1, getterName, String.format("()%s", this.getJavaType(fieldType)), null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitFieldInsn(180, beanNameWithPackage, fieldName, this.getJavaType(fieldType));
        codeVisitor.visitInsn(this.getConstantForReturn(fieldType));
        if (Long.TYPE.equals(fieldType.getType()) || Double.TYPE.equals(fieldType.getType())) {
            codeVisitor.visitMaxs(2, 1);
        } else {
            codeVisitor.visitMaxs(1, 1);
        }
    }

    private int getConstantForReturn(FieldType fieldType) {
        Class<?> retClass = fieldType.getType();
        if (retClass != null) {
            return this.getConstantForReturn(retClass);
        }
        return 176;
    }

    private int getConstantForReturn(Class<?> fieldClass) {
        if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Short.TYPE) || fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Character.TYPE) || fieldClass.equals(Byte.TYPE)) {
            return 172;
        }
        if (fieldClass.equals(Long.TYPE)) {
            return 173;
        }
        if (fieldClass.equals(Double.TYPE)) {
            return 175;
        }
        if (fieldClass.equals(Float.TYPE)) {
            return 174;
        }
        if (fieldClass instanceof Object) {
            return 176;
        }
        return 0;
    }

    private void generateSetter(String beanNameWithPackage, ClassWriter classWriter, Map.Entry<String, FieldType> field) {
        String fieldName = field.getKey();
        FieldType fieldType = field.getValue();
        String setterName = StringTool.getSetterName((String)field.getKey());
        CodeVisitor codeVisitor = classWriter.visitMethod(1, setterName, String.format("(%s)V", this.getJavaType(fieldType)), null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitVarInsn(this.getConstantForVarInsn(fieldType), 1);
        codeVisitor.visitFieldInsn(181, beanNameWithPackage, fieldName, this.getJavaType(fieldType));
        codeVisitor.visitInsn(177);
        if (Long.TYPE.equals(fieldType.getType()) || Double.TYPE.equals(fieldType.getType())) {
            codeVisitor.visitMaxs(3, 3);
        } else {
            codeVisitor.visitMaxs(2, 2);
        }
    }

    private int getConstantForVarInsn(FieldType fieldType) {
        Class<?> retClass = fieldType.getType();
        if (retClass != null) {
            return this.getConstantForVarInsn(retClass);
        }
        return 25;
    }

    private int getConstantForVarInsn(Class<?> fieldClass) {
        if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Short.TYPE) || fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Character.TYPE) || fieldClass.equals(Byte.TYPE)) {
            return 21;
        }
        if (fieldClass.equals(Long.TYPE)) {
            return 22;
        }
        if (fieldClass.equals(Double.TYPE)) {
            return 24;
        }
        if (fieldClass.equals(Float.TYPE)) {
            return 23;
        }
        if (fieldClass instanceof Object) {
            return 25;
        }
        return 0;
    }

    private Class<?> loadClass(byte[] byteCode) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return ReflectUtils.defineClass((String)this.beanName, (byte[])byteCode, (ClassLoader)classLoader);
        }
        catch (Exception ex) {
            this.LOG.debug((Object)this, (Throwable)ex);
            try {
                return Class.forName(this.beanName, true, classLoader);
            }
            catch (Exception e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
            catch (VerifyError exc) {
                this.LOG.error((Object)this, (Throwable)exc);
            }
            return null;
        }
    }

    private Class<?> getJavaClass(FieldType fieldType) {
        if (fieldType.getType() == null) {
            return Object.class;
        }
        return fieldType.getType();
    }

    private String getJavaType(Class<?> fieldClass) {
        return String.valueOf(Type.getType(fieldClass));
    }

    private String getJavaType(FieldType fieldType) {
        Class<?> fieldClass = fieldType.getType();
        if (fieldClass != null) {
            return this.getJavaType(fieldClass);
        }
        return JavaClassGeneratorHelper.getJavaType((String)fieldType.getTypeName());
    }

    private Map<String, FieldType> convertFields(Map<String, IOpenField> fieldsToConvert) {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (Map.Entry<String, IOpenField> field : fieldsToConvert.entrySet()) {
            fields.put(field.getKey(), new FieldType(field.getValue()));
        }
        return fields;
    }

    private int getTwoStackElementFieldsCount(Map<String, FieldType> fields) {
        int twoStackElementsCount = 0;
        for (FieldType fieldType : fields.values()) {
            if (!Long.TYPE.equals(fieldType.getType()) && !Double.TYPE.equals(fieldType.getType())) continue;
            ++twoStackElementsCount;
        }
        return twoStackElementsCount;
    }

    private void invokeVirtual(CodeVisitor codeVisitor, Class<?> methodOwner, String methodName, Class<?>[] paramTypes) {
        String signatureBuilder = this.getSignature(methodOwner, methodName, paramTypes);
        codeVisitor.visitMethodInsn(182, Type.getInternalName(methodOwner), methodName, signatureBuilder);
    }

    private void invokeStatic(CodeVisitor codeVisitor, Class<?> methodOwner, String methodName, Class<?>[] paramTypes) {
        String signatureBuilder = this.getSignature(methodOwner, methodName, paramTypes);
        codeVisitor.visitMethodInsn(184, Type.getInternalName(methodOwner), methodName, signatureBuilder);
    }

    private String getMethodSignatureForByteCode(Map<String, FieldType> params, Class<?> returnType) {
        StringBuilder signatureBuilder = new StringBuilder("(");
        for (Map.Entry<String, FieldType> field : params.entrySet()) {
            String javaType = this.getJavaType(field.getValue());
            signatureBuilder.append(javaType);
        }
        signatureBuilder.append(")");
        if (returnType == null) {
            signatureBuilder.append("V");
        } else {
            signatureBuilder.append(this.getJavaType(returnType));
        }
        return signatureBuilder.toString();
    }

    private String getSignature(Class<?> methodOwner, String methodName, Class<?>[] paramTypes) {
        Method matchingMethod = MethodUtil.getMatchingAccessibleMethod(methodOwner, (String)methodName, (Class[])paramTypes, (boolean)false);
        StringBuilder signatureBuilder = new StringBuilder();
        signatureBuilder.append('(');
        for (Class<?> paramType : matchingMethod.getParameterTypes()) {
            signatureBuilder.append(this.getJavaType(paramType));
        }
        signatureBuilder.append(')');
        signatureBuilder.append(this.getJavaType(matchingMethod.getReturnType()));
        return signatureBuilder.toString();
    }

    private void pushFieldToStack(CodeVisitor codeVisitor, int fieldOwnerLocalVarIndex, String fieldName) {
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitFieldInsn(180, this.beanNameWithPackage, fieldName, this.getJavaType(this.allFields.get(fieldName)));
    }

    public String toString() {
        if (StringUtils.isNotBlank((String)this.beanName)) {
            return String.format("Bean with name: %s", this.beanName);
        }
        return super.toString();
    }
}

