/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.domaintree;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openl.meta.DoubleValue;
import org.openl.meta.IMetaInfo;
import org.openl.rules.domaintree.DomainTreeContext;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.ArrayOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainTree {
    private static final Set<String> ignoredTypes;
    private static Map<String, IOpenClass> predefinedTypes;
    private final Map<String, IOpenClass> treeElements = new HashMap<String, IOpenClass>(predefinedTypes);

    public static DomainTree buildTree(IOpenClass projectOpenClass, boolean addDatatypes) {
        if (projectOpenClass instanceof NullOpenClass) {
            throw new IllegalArgumentException("Module is corrupted.");
        }
        IMetaInfo projectInfo = projectOpenClass.getMetaInfo();
        if (projectInfo instanceof XlsMetaInfo) {
            Map dataTypes;
            DomainTree domainTree = new DomainTree();
            if (addDatatypes && (dataTypes = projectOpenClass.getTypes()).size() > 0) {
                for (IOpenClass type : dataTypes.values()) {
                    domainTree.addType(type);
                }
            }
            return domainTree;
        }
        throw new IllegalArgumentException("Only XlsMetaInfo is currenty supported");
    }

    public static DomainTree buildTree(IOpenClass projectOpenClass) {
        return DomainTree.buildTree(projectOpenClass, true);
    }

    private static boolean inspectTypeRecursively(IOpenClass type) {
        return !type.isSimple();
    }

    private static boolean isAppropriateProperty(IOpenField field) {
        return !field.isStatic() && !field.getType().isAbstract();
    }

    private boolean isArrayType(IOpenClass fieldType) {
        return fieldType instanceof ArrayOpenClass;
    }

    private DomainTree() {
    }

    private boolean addType(IOpenClass type) {
        String simpleTypeName;
        if (this.isArrayType(type)) {
            type = this.getComponentType(type);
        }
        if (!this.treeElements.containsKey(simpleTypeName = type.getDisplayName(0)) && !ignoredTypes.contains(simpleTypeName)) {
            Class instanceClass = type.getInstanceClass();
            if (instanceClass != null && Collection.class.isAssignableFrom(instanceClass)) {
                return false;
            }
            this.treeElements.put(simpleTypeName, type);
            if (DomainTree.inspectTypeRecursively(type)) {
                Map fields = type.getFields();
                for (IOpenField field : fields.values()) {
                    if (!DomainTree.isAppropriateProperty(field)) continue;
                    this.addType(field.getType());
                }
            }
            return true;
        }
        return false;
    }

    private IOpenClass getComponentType(IOpenClass type) {
        IOpenClass result = null;
        if (this.isArrayType(type)) {
            IOpenClass componentType = ((ArrayOpenClass)type).getComponentClass();
            result = componentType != null ? componentType : type;
        }
        return result;
    }

    public Collection<String> getAllClasses(boolean sorted) {
        Set<String> unsortedClasses = this.treeElements.keySet();
        if (sorted) {
            ArrayList<String> sortedClasses = new ArrayList<String>(unsortedClasses);
            Collections.sort(sortedClasses, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    boolean primitive2;
                    boolean primitive1 = predefinedTypes.containsKey(s1);
                    if (primitive1 == (primitive2 = predefinedTypes.containsKey(s2))) {
                        boolean defPackage2;
                        boolean defPackage1 = s1.startsWith("java.");
                        if (defPackage1 != (defPackage2 = s2.startsWith("java."))) {
                            if (primitive1) {
                                return defPackage2 ? -1 : 1;
                            }
                            return defPackage1 ? -1 : 1;
                        }
                        return s1.compareTo(s2);
                    }
                    return primitive1 ? -1 : 1;
                }
            });
            return sortedClasses;
        }
        return unsortedClasses;
    }

    public Collection<String> getClassProperties(String typename) {
        IOpenClass openClass = this.treeElements.get(typename);
        if (openClass == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Map fields = openClass.getFields();
        for (IOpenField field : fields.values()) {
            if (!DomainTree.isAppropriateProperty(field)) continue;
            result.add(field.getName());
        }
        return result;
    }

    public String getTypename(DomainTreeContext context, String path) {
        if (path == null) {
            return null;
        }
        String[] parts = path.split("\\.");
        if (parts.length == 0) {
            return null;
        }
        String rootClassname = context.getObjectType(parts[0]);
        if (rootClassname == null) {
            return null;
        }
        IOpenClass openClass = this.treeElements.get(rootClassname);
        if (openClass == null) {
            return null;
        }
        for (int i = 1; i < parts.length; ++i) {
            IOpenField field = openClass.getField(parts[i]);
            if (field == null) {
                return null;
            }
            openClass = field.getType();
        }
        return openClass.getName();
    }

    static {
        predefinedTypes = new TreeMap<String, IOpenClass>();
        ignoredTypes = new HashSet<String>();
        ignoredTypes.add(JavaOpenClass.OBJECT.getSimpleName());
        ignoredTypes.add(JavaOpenClass.CLASS.getSimpleName());
        ignoredTypes.add(JavaOpenClass.VOID.getSimpleName());
        predefinedTypes = new HashMap<String, IOpenClass>();
        predefinedTypes.put(JavaOpenClass.INT.getSimpleName(), (IOpenClass)JavaOpenClass.INT);
        predefinedTypes.put(JavaOpenClass.BOOLEAN.getSimpleName(), (IOpenClass)JavaOpenClass.BOOLEAN);
        predefinedTypes.put(JavaOpenClass.LONG.getSimpleName(), (IOpenClass)JavaOpenClass.LONG);
        predefinedTypes.put(JavaOpenClass.DOUBLE.getSimpleName(), (IOpenClass)JavaOpenClass.DOUBLE);
        predefinedTypes.put(JavaOpenClass.FLOAT.getSimpleName(), (IOpenClass)JavaOpenClass.FLOAT);
        predefinedTypes.put(JavaOpenClass.SHORT.getSimpleName(), (IOpenClass)JavaOpenClass.SHORT);
        predefinedTypes.put(JavaOpenClass.CHAR.getSimpleName(), (IOpenClass)JavaOpenClass.CHAR);
        predefinedTypes.put(JavaOpenClass.STRING.getSimpleName(), (IOpenClass)JavaOpenClass.STRING);
        predefinedTypes.put("Date", (IOpenClass)JavaOpenClass.getOpenClass(Date.class));
        predefinedTypes.put("BigInteger", (IOpenClass)JavaOpenClass.getOpenClass(BigInteger.class));
        predefinedTypes.put("BigDecimal", (IOpenClass)JavaOpenClass.getOpenClass(BigDecimal.class));
        predefinedTypes.put("IntRange", (IOpenClass)JavaOpenClass.getOpenClass(IntRange.class));
        predefinedTypes.put("DoubleRange", (IOpenClass)JavaOpenClass.getOpenClass(DoubleRange.class));
        predefinedTypes.put("DoubleValue", (IOpenClass)JavaOpenClass.getOpenClass(DoubleValue.class));
    }
}

