/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.module.ModuleBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.annotations.Executable;
import org.openl.rules.dt.DecisionTableInvoker;
import org.openl.rules.dt.algorithm.DecisionTableOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.types.impl.AMethod;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Executable
public class DecisionTable
extends AMethod
implements IMemberMetaInfo {
    private ICondition[] conditionRows;
    private IAction[] actionRows;
    private RuleRow ruleRow;
    private int columns;
    private TableSyntaxNode tableSyntaxNode;
    private DecisionTableOptimizedAlgorithm algorithm;
    private Map<String, Object> properties;
    private Invokable invoker;
    IOpenClass ruleExecutionType;

    public DecisionTable(IOpenMethodHeader header) {
        super(header);
    }

    public IAction[] getActionRows() {
        return this.actionRows;
    }

    public DecisionTableOptimizedAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getColumns() {
        return this.columns;
    }

    public ICondition[] getConditionRows() {
        return this.conditionRows;
    }

    public String getDisplayName(int mode) {
        return this.getHeader().getInfo().getDisplayName(mode);
    }

    public ILogicalTable getDisplayTable() {
        ILogicalTable table = this.tableSyntaxNode.getSubTables().get("view.business");
        return (ILogicalTable)table.getColumn(0);
    }

    public IMemberMetaInfo getInfo() {
        return this;
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public int getNumberOfRules() {
        if (this.actionRows.length > 0) {
            return this.actionRows[0].getParamValues().length;
        }
        return 0;
    }

    public String getRuleName(int col) {
        return this.ruleRow == null ? "R" + (col + 1) : this.ruleRow.getRuleName(col);
    }

    public RuleRow getRuleRow() {
        return this.ruleRow;
    }

    public ILogicalTable getRuleTable(int col) {
        ILogicalTable table = this.tableSyntaxNode.getSubTables().get("view.business");
        return (ILogicalTable)table.getColumn(col + 1);
    }

    public ILogicalTable getRuleByIndex(int ruleNumber) {
        ILogicalTable dt = this.actionRows[0].getDecisionTable();
        int starColumn = dt.getWidth() - this.columns;
        return (ILogicalTable)dt.getColumn(starColumn + ruleNumber);
    }

    public String getSourceUrl() {
        return this.tableSyntaxNode.getUri();
    }

    public TableSyntaxNode getSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public void setActionRows(IAction[] actionRows) {
        this.actionRows = actionRows;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setConditionRows(ICondition[] conditionRows) {
        this.conditionRows = conditionRows;
    }

    public void setRuleRow(RuleRow ruleRow) {
        this.ruleRow = ruleRow;
    }

    public void setTableSyntaxNode(TableSyntaxNode tsn) {
        this.tableSyntaxNode = tsn;
    }

    public void bindTable(ICondition[] conditionRows, IAction[] actionRows, RuleRow ruleRow, OpenL openl, ModuleOpenClass module, IBindingContextDelegator cxtd, int columns) throws Exception {
        this.conditionRows = conditionRows;
        this.actionRows = actionRows;
        this.properties = this.tableSyntaxNode.getTableProperties().getAllProperties();
        if (!cxtd.isExecutionMode()) {
            this.ruleRow = ruleRow;
        }
        this.columns = columns;
        this.prepare(this.getHeader(), openl, module, cxtd);
    }

    public BindingDependencies getDependencies() {
        BindingDependencies bindingDependencies = new BindingDependencies();
        this.updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.invoker == null) {
            this.invoker = new DecisionTableInvoker(this);
        }
        return this.invoker.invoke(target, params, env);
    }

    public boolean shouldFailOnMiss() {
        return (Boolean)this.properties.get("failOnMiss");
    }

    protected void makeAlgorithm(IConditionEvaluator[] evs) throws Exception {
        this.algorithm = new DecisionTableOptimizedAlgorithm(evs, this);
        this.algorithm.buildIndex();
    }

    private void prepare(IOpenMethodHeader header, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator) throws Exception {
        IMethodSignature signature = header.getSignature();
        IConditionEvaluator[] evaluators = this.prepareConditions(openl, module, bindingContextDelegator, signature);
        this.prepareActions(header, openl, module, bindingContextDelegator, signature);
        this.makeAlgorithm(evaluators);
    }

    private void prepareActions(IOpenMethodHeader header, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator, IMethodSignature signature) throws Exception {
        ModuleBindingContext actionBindingContextDelegator = new ModuleBindingContext((IBindingContext)bindingContextDelegator, (ModuleOpenClass)this.getRuleExecutionType(openl));
        for (int i = 0; i < this.actionRows.length; ++i) {
            JavaOpenClass methodType = this.actionRows[i].isReturnAction() ? header.getType() : JavaOpenClass.VOID;
            this.actionRows[i].prepareAction((IOpenClass)methodType, signature, openl, module, (IBindingContextDelegator)actionBindingContextDelegator, this.ruleRow, this.getRuleExecutionType(openl));
        }
    }

    private IConditionEvaluator[] prepareConditions(OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator, IMethodSignature signature) throws Exception {
        IConditionEvaluator[] evaluators = new IConditionEvaluator[this.conditionRows.length];
        for (int i = 0; i < this.conditionRows.length; ++i) {
            evaluators[i] = this.conditionRows[i].prepareCondition(signature, openl, module, bindingContextDelegator, this.ruleRow);
        }
        return evaluators;
    }

    public String toString() {
        return this.getName();
    }

    public void updateDependency(BindingDependencies dependencies) {
        int i;
        for (i = 0; i < this.conditionRows.length; ++i) {
            ((CompositeMethod)this.conditionRows[i].getMethod()).updateDependency(dependencies);
            this.updateValueDependency((FunctionalRow)((Object)this.conditionRows[i]), dependencies);
        }
        for (i = 0; i < this.actionRows.length; ++i) {
            ((CompositeMethod)this.actionRows[i].getMethod()).updateDependency(dependencies);
            this.updateValueDependency((FunctionalRow)((Object)this.actionRows[i]), dependencies);
        }
    }

    protected void updateValueDependency(FunctionalRow frow, BindingDependencies dependencies) {
        Object[][] values = frow.getParamValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            for (int j = 0; j < values[i].length; ++j) {
                if (!(values[i][j] instanceof CompositeMethod)) continue;
                ((CompositeMethod)values[i][j]).updateDependency(dependencies);
            }
        }
    }

    private synchronized IOpenClass getRuleExecutionType(OpenL openl) {
        if (this.ruleExecutionType == null) {
            this.ruleExecutionType = new DecisionTableDataType(this, null, this.getName() + "Type", openl);
        }
        return this.ruleExecutionType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

