/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableColumnHeaders;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.CompositeGrid;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.xls.XlsSheetGridHelper;

public class DecisionTableHelper {
    public static boolean looksLikeVertical(ILogicalTable table) {
        int cnt2;
        if (table.getWidth() <= 4) {
            return true;
        }
        if (table.getHeight() <= 4) {
            return false;
        }
        int cnt1 = DecisionTableHelper.countConditionsAndActions(table);
        if (cnt1 != (cnt2 = DecisionTableHelper.countConditionsAndActions((ILogicalTable)table.transpose()))) {
            return cnt1 > cnt2;
        }
        return table.getWidth() <= 4;
    }

    public static boolean isValidConditionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.CONDITION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidActionHeader(String s) {
        return s.length() >= 2 && s.charAt(0) == DecisionTableColumnHeaders.ACTION.getHeaderKey().charAt(0) && Character.isDigit(s.charAt(1));
    }

    public static boolean isValidRetHeader(String s) {
        return s.length() >= 3 && s.startsWith(DecisionTableColumnHeaders.RETURN.getHeaderKey()) && (s.length() == 3 || Character.isDigit(s.charAt(3)));
    }

    public static boolean isValidRuleHeader(String s) {
        return s.equals(DecisionTableColumnHeaders.RULE.getHeaderKey());
    }

    public static boolean isValidCommentHeader(String s) {
        return s.startsWith("//");
    }

    public static boolean isActionHeader(String s) {
        return DecisionTableHelper.isValidActionHeader(s) || DecisionTableHelper.isValidRetHeader(s);
    }

    public static boolean isConditionHeader(String s) {
        return DecisionTableHelper.isValidConditionHeader(s) || DecisionTableHelper.isValidHConditionHeader(s);
    }

    public static int countConditionsAndActions(ILogicalTable table) {
        int width = table.getWidth();
        int count = 0;
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null) continue;
            count += DecisionTableHelper.isValidConditionHeader(value = value.toUpperCase()) || DecisionTableHelper.isActionHeader(value) ? 1 : 0;
        }
        return count;
    }

    public static boolean hasHConditions(ILogicalTable table) {
        int width = table.getWidth();
        for (int i = 0; i < width; ++i) {
            String value = ((ILogicalTable)table.getColumn(i)).getSource().getCell(0, 0).getStringValue();
            if (value == null || !DecisionTableHelper.isValidHConditionHeader(value = value.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidHConditionHeader(String headerStr) {
        return headerStr.startsWith(DecisionTableColumnHeaders.HORIZONTAL_CONDITION.getHeaderKey()) && headerStr.length() > 2 && Character.isDigit(headerStr.charAt(2));
    }

    public static ILogicalTable preprocessSimpleDecisionTable(DecisionTable decisionTable, ILogicalTable originalTable, int numberOfHcondition) throws OpenLCompilationException {
        IWritableGrid virtualGrid = DecisionTableHelper.createVirtualGrid();
        DecisionTableHelper.writeVirtualHeadersForSimpleDecisionTable(virtualGrid, originalTable, decisionTable, numberOfHcondition);
        GridTable virtualGridTable = new GridTable(0, 0, 2, originalTable.getSource().getWidth() - 1, virtualGrid);
        CompositeGrid grid = new CompositeGrid(new IGridTable[]{virtualGridTable, originalTable.getSource()}, true);
        return LogicalTableHelper.logicalTable(new GridTable(0, 0, originalTable.getSource().getHeight() + 3 - 1, originalTable.getSource().getWidth() - 1, grid));
    }

    private static void writeVirtualHeadersForSimpleDecisionTable(IWritableGrid grid, ILogicalTable originalTable, DecisionTable decisionTable, int numberOfHcondition) throws OpenLCompilationException {
        int numberOfConditions = decisionTable.getSignature().getNumberOfParameters();
        int column = 0;
        for (int i = 0; i < numberOfConditions; ++i) {
            if (column > originalTable.getWidth()) {
                throw new OpenLCompilationException("Wrong table structure: Columns count is less than parameters count");
            }
            if (i < numberOfConditions - numberOfHcondition) {
                grid.setCellValue(column, 0, "C" + (i + 1));
            } else {
                grid.setCellValue(column, 0, "HC" + (i + 1));
            }
            grid.setCellValue(column, 1, decisionTable.getSignature().getParameterName(i));
            int mergedColumnsCounts = originalTable.getColumnWidth(i);
            if (mergedColumnsCounts > 1) {
                for (int row = 0; row < 3; ++row) {
                    grid.addMergedRegion(new GridRegion(row, column, row, column + mergedColumnsCounts - 1));
                }
            }
            column += mergedColumnsCounts;
        }
        if (column > originalTable.getWidth()) {
            throw new OpenLCompilationException("Wrong table structure: There is no column for return values");
        }
        grid.setCellValue(column, 0, "RET1");
        int mergedColumnsCounts = originalTable.getColumnWidth(numberOfConditions);
        if (mergedColumnsCounts > 1) {
            for (int row = 0; row < 3; ++row) {
                grid.addMergedRegion(new GridRegion(row, column, row, column + mergedColumnsCounts - 1));
            }
        }
    }

    public static IWritableGrid createVirtualGrid() {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        return XlsSheetGridHelper.createVirtualGrid((Sheet)sheet);
    }

    public static boolean isSimpleDecisionTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleRules".equals(dtType);
    }

    public static boolean isSimpleLookupTable(TableSyntaxNode tableSyntaxNode) {
        String dtType = tableSyntaxNode.getHeader().getHeaderToken().getIdentifier();
        return "SimpleLookup".equals(dtType);
    }
}

