/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.binding.MethodUtil;
import org.openl.domain.IIntIterator;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.algorithm.FailOnMissException;
import org.openl.rules.dt.trace.DecisionTableTraceObject;
import org.openl.rules.table.DefaultInvokerWithTrace;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.Tracer;

public class DecisionTableInvoker
extends DefaultInvokerWithTrace {
    private final Log LOG = LogFactory.getLog(DecisionTableInvoker.class);
    private DecisionTable decisionTable;

    public DecisionTableInvoker(DecisionTable decisionTable) {
        this.decisionTable = decisionTable;
    }

    public boolean canInvoke() {
        return this.decisionTable.getAlgorithm() != null;
    }

    private Object invokeOptimized(Object target, Object[] params, IRuntimeEnv env) {
        IIntIterator rules = this.decisionTable.getAlgorithm().checkedRules(target, params, env);
        Object returnValue = null;
        boolean atLeastOneRuleFired = false;
        while (rules.hasNext()) {
            atLeastOneRuleFired = true;
            int ruleN = rules.nextInt();
            for (int j = 0; j < this.decisionTable.getActionRows().length; ++j) {
                Object actionResult = this.decisionTable.getActionRows()[j].executeAction(ruleN, target, params, env);
                if (!this.decisionTable.getActionRows()[j].isReturnAction() || returnValue != null || actionResult == null && (this.decisionTable.getActionRows()[j].getParamValues() == null || this.decisionTable.getActionRows()[j].getParamValues()[ruleN] == null)) continue;
                returnValue = actionResult;
            }
            if (returnValue == null) continue;
            return returnValue;
        }
        if (!atLeastOneRuleFired && this.decisionTable.shouldFailOnMiss()) {
            String method = MethodUtil.printMethodWithParameterValues((IOpenMethod)this.decisionTable.getMethod(), (Object[])params, (int)1);
            String message = String.format("%s failed to match any rule condition", method);
            throw new FailOnMissException(message, this.decisionTable, params);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeTracedOptimized(Object target, Object[] params, IRuntimeEnv env) {
        Tracer tracer = Tracer.getTracer();
        if (tracer == null) {
            return this.invokeOptimized(target, params, env);
        }
        Object ret = null;
        DecisionTableTraceObject traceObject = new DecisionTableTraceObject(this.decisionTable, params);
        tracer.push((ITracerObject)traceObject);
        try {
            IIntIterator rules = this.decisionTable.getAlgorithm().checkedRules(target, params, env);
            while (rules.hasNext()) {
                int ruleN = rules.nextInt();
                try {
                    tracer.push((ITracerObject)traceObject.traceRule(ruleN));
                    for (int j = 0; j < this.decisionTable.getActionRows().length; ++j) {
                        Object actionResult = this.decisionTable.getActionRows()[j].executeAction(ruleN, target, params, env);
                        if (!this.decisionTable.getActionRows()[j].isReturnAction() || ret != null || actionResult == null && (this.decisionTable.getActionRows()[j].getParamValues() == null || this.decisionTable.getActionRows()[j].getParamValues()[ruleN] == null)) continue;
                        ret = actionResult;
                    }
                    if (ret == null) continue;
                    traceObject.setResult(ret);
                    Object object = ret;
                    return object;
                }
                finally {
                    tracer.pop();
                }
            }
        }
        catch (RuntimeException e) {
            this.addErrorToTrace(traceObject, e);
        }
        finally {
            tracer.pop();
        }
        return ret;
    }

    private void addErrorToTrace(DecisionTableTraceObject traceObject, Throwable e) {
        traceObject.setError(e);
        this.LOG.error((Object)"Error when tracing DT rule", e);
        throw new OpenLRuntimeException(e);
    }

    public DecisionTableTraceObject createTraceObject(Object[] params) {
        return new DecisionTableTraceObject(this.decisionTable, params);
    }

    public Object invokeTraced(Object target, Object[] params, IRuntimeEnv env) {
        return this.invokeTracedOptimized(target, params, env);
    }

    public OpenLRuntimeException getError() {
        return new OpenLRuntimeException((Throwable)this.decisionTable.getSyntaxNode().getErrors()[0]);
    }

    public Object invokeSimple(Object target, Object[] params, IRuntimeEnv env) {
        return this.invokeOptimized(target, params, env);
    }
}

