/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.DecisionTableLookupConvertor;
import org.openl.rules.dt.element.Action;
import org.openl.rules.dt.element.Condition;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class DecisionTableLoader {
    protected static final String EMPTY_BODY = "Decision table must contain body section.";
    private int columnsNumber;
    private RuleRow ruleRow;
    private List<ICondition> conditions = new ArrayList<ICondition>();
    private List<IAction> actions = new ArrayList<IAction>();

    private void addAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, false));
    }

    private void addCondition(String name, int row, ILogicalTable table) {
        this.conditions.add(new Condition(name, row, table));
    }

    private void addReturnAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, true));
    }

    private void addRule(int row, ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        if (this.ruleRow != null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Only one rule row/column allowed", (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        this.ruleRow = new RuleRow(row, table);
    }

    public DecisionTable loadAndBind(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContext) throws Exception {
        this.loadTableStructure(tableSyntaxNode, decisionTable, (IBindingContext)bindingContext);
        ICondition[] conditionsArray = this.conditions.toArray(new ICondition[this.conditions.size()]);
        IAction[] actionsArray = this.actions.toArray(new IAction[this.actions.size()]);
        decisionTable.bindTable(conditionsArray, actionsArray, this.ruleRow, openl, module, bindingContext, this.columnsNumber);
        return decisionTable;
    }

    private void loadTableStructure(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) throws SyntaxNodeException {
        decisionTable.setTableSyntaxNode(tableSyntaxNode);
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw new SyntaxNodeException(EMPTY_BODY, null, (ISyntaxNode)tableSyntaxNode);
        }
        try {
            tableBody = this.preprocessSimpleDecisionTable(tableSyntaxNode, decisionTable, tableBody);
        }
        catch (OpenLCompilationException e) {
            throw new SyntaxNodeException("Cannot create header for simle Decision Tbale", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
        }
        ILogicalTable toParse = tableBody;
        if (this.hasHConditions(tableBody)) {
            try {
                IGridTable convertedTable = new DecisionTableLookupConvertor().convertTable(tableBody);
                ILogicalTable offsetConvertedTable = LogicalTableHelper.logicalTable(convertedTable);
                toParse = (ILogicalTable)offsetConvertedTable.transpose();
            }
            catch (Exception e) {
                throw new SyntaxNodeException("Cannot convert table", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        } else if (DecisionTableHelper.looksLikeVertical(tableBody)) {
            toParse = (ILogicalTable)tableBody.transpose();
        }
        if (toParse.getWidth() < 4) {
            throw new SyntaxNodeException("Invalid structure of decision table", null, (ISyntaxNode)tableSyntaxNode);
        }
        this.columnsNumber = toParse.getWidth() - 4;
        this.putTableForBusinessView(tableSyntaxNode);
        for (int i = 0; i < toParse.getHeight(); ++i) {
            this.loadRow(i, toParse, bindingContext);
        }
    }

    private void putTableForBusinessView(TableSyntaxNode tableSyntaxNode) {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode)) {
            tableSyntaxNode.getSubTables().put("view.business", tableBody);
        } else {
            ILogicalTable businessView = null;
            businessView = DecisionTableHelper.looksLikeVertical(tableBody) ? (ILogicalTable)tableBody.getRows(3) : (ILogicalTable)tableBody.getColumns(3);
            tableSyntaxNode.getSubTables().put("view.business", businessView);
        }
    }

    private ILogicalTable preprocessSimpleDecisionTable(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, ILogicalTable tableBody) throws OpenLCompilationException {
        if (DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode)) {
            tableBody = DecisionTableHelper.preprocessSimpleDecisionTable(decisionTable, tableBody, 0);
        } else if (DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode)) {
            tableBody = DecisionTableHelper.preprocessSimpleDecisionTable(decisionTable, tableBody, tableBody.getSource().getCell(0, 0).getHeight());
        }
        return tableBody;
    }

    private boolean hasHConditions(ILogicalTable tableBody) {
        return DecisionTableHelper.hasHConditions(tableBody);
    }

    private void loadRow(int row, ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        String headerStr = ((ILogicalTable)table.getRow(row)).getSource().getCell(0, 0).getStringValue();
        if (headerStr == null) {
            return;
        }
        String header = headerStr.toUpperCase();
        if (DecisionTableHelper.isConditionHeader(header)) {
            this.addCondition(headerStr, row, table);
        } else if (DecisionTableHelper.isValidActionHeader(header)) {
            this.addAction(headerStr, row, table);
        } else if (DecisionTableHelper.isValidRuleHeader(header)) {
            this.addRule(row, table, bindingContext);
        } else if (DecisionTableHelper.isValidRetHeader(header)) {
            this.addReturnAction(headerStr, row, table);
        } else if (!DecisionTableHelper.isValidCommentHeader(header)) {
            throw SyntaxNodeExceptionUtils.createError((String)("Invalid Decision Table header:" + headerStr), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
    }
}

