/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.dt.TwoDimensionDecisionTableTranformer;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.Point;

public class LookupHeadersTransformer
extends TwoDimensionDecisionTableTranformer {
    private int retStartIndex = 0;
    private int hcColumnStartAfterRet = 0;
    private int firstEmptyCell = 0;

    public LookupHeadersTransformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth, int retColumnStartIndex, int firstEmptyCell) {
        super(entireTable, lookupValuesTable, retTableWidth);
        this.retStartIndex = retColumnStartIndex;
        this.firstEmptyCell = firstEmptyCell;
        this.hcColumnStartAfterRet = this.retStartIndex + this.getRetTableWidth();
    }

    protected Point getCoordinatesFromConditionHeaders(int column, int row) {
        if (column < this.retStartIndex) {
            return super.getCoordinatesFromConditionHeaders(column, row);
        }
        if (this.retStartIndex <= column && column < this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet) {
            return new Point(column + this.getRetTableWidth(), row);
        }
        if (this.retStartIndex + this.firstEmptyCell - this.hcColumnStartAfterRet <= column && column < this.firstEmptyCell) {
            return new Point(column - (this.firstEmptyCell - this.hcColumnStartAfterRet), row);
        }
        return super.getCoordinatesFromConditionHeaders(column, row);
    }
}

