/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.Point;

public class TwoDimensionDecisionTableTranformer
implements CoordinatesTransformer {
    private static final int CONDITION_HEADERS_HEIGHT = 4;
    protected static final int HCONDITION_HEADERS_HEIGHT = 3;
    private int conditionsWidth;
    private int hConditionsCount;
    private int lookupValuesTableHeight;
    private int lookupValuesTableWidth;
    private int retTableWidth;
    private int dtHeaderHeight;

    public TwoDimensionDecisionTableTranformer(int conditionsCount, int hConditionsCount, int lookupValuesTableHeight, int lookupValuesTableWidth, int retTableWidth) {
        this.conditionsWidth = conditionsCount;
        this.hConditionsCount = hConditionsCount;
        this.lookupValuesTableHeight = lookupValuesTableHeight;
        this.lookupValuesTableWidth = lookupValuesTableWidth;
        this.retTableWidth = retTableWidth;
        this.dtHeaderHeight = 4 + (hConditionsCount - 1);
    }

    public TwoDimensionDecisionTableTranformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth) {
        this.lookupValuesTableHeight = lookupValuesTable.getHeight();
        this.lookupValuesTableWidth = lookupValuesTable.getWidth();
        this.conditionsWidth = entireTable.getWidth() - this.lookupValuesTableWidth;
        this.hConditionsCount = entireTable.getHeight() - this.lookupValuesTableHeight - 3;
        this.retTableWidth = retTableWidth;
        this.dtHeaderHeight = 4 + (this.hConditionsCount - 1);
    }

    public Point calculateCoordinates(int column, int row) {
        if (row < this.dtHeaderHeight) {
            return this.getCoordinatesFromConditionHeaders(column, row);
        }
        if (column < this.conditionsWidth) {
            return this.getCoordinatesFromConditionValues(column, row);
        }
        if (column < this.conditionsWidth + this.hConditionsCount) {
            return this.getCoordinatesFromHConditionValues(column, row);
        }
        return this.getCoordinatesFromLookupValues(column, row);
    }

    protected int getRetTableWidth() {
        return this.retTableWidth;
    }

    protected Point getCoordinatesFromConditionHeaders(int column, int row) {
        return new Point(column, row);
    }

    private Point getCoordinatesFromConditionValues(int column, int row) {
        int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
        return new Point(column, this.dtHeaderHeight + conditionValueIndex);
    }

    private Point getCoordinatesFromHConditionValues(int column, int row) {
        int hConditionIndex = column - this.conditionsWidth;
        int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
        return new Point(this.conditionsWidth + hConditionValueIndex, 3 + hConditionIndex);
    }

    private Point getCoordinatesFromLookupValues(int column, int row) {
        int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
        int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
        return new Point(this.conditionsWidth + hConditionValueIndex + (column - this.conditionsWidth - this.hConditionsCount), 3 + this.hConditionsCount + conditionValueIndex);
    }

    public int getHeight() {
        return this.dtHeaderHeight + this.lookupValuesTableWidth / this.retTableWidth * this.lookupValuesTableHeight;
    }

    public int getWidth() {
        return this.conditionsWidth + this.hConditionsCount + this.retTableWidth;
    }
}

