/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.binding.BindingDependencies;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.domain.IntRangeDomain;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.algorithm.evaluator.ContainsInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.ContainsInOrNotInArrayIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.EqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.RangeIndexedEvaluator;
import org.openl.rules.dt.data.ConditionOrActionParameterField;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.type.BooleanAdaptorFactory;
import org.openl.rules.dt.type.BooleanTypeAdaptor;
import org.openl.rules.dt.type.DoubleRangeAdaptor;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.dt.type.IntRangeAdaptor;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableOptimizedAlgorithm {
    private IConditionEvaluator[] evaluators;
    private DecisionTable table;
    private ARuleIndex indexRoot;
    private BindingDependencies dependencies;

    public DecisionTableOptimizedAlgorithm(IConditionEvaluator[] evaluators, DecisionTable table) {
        this.evaluators = evaluators;
        this.table = table;
        this.dependencies = new BindingDependencies();
        table.updateDependency(this.dependencies);
    }

    public IConditionEvaluator[] getEvaluators() {
        return this.evaluators;
    }

    private Object evaluateTestValue(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        return condition.getEvaluator().invoke(target, dtparams, env);
    }

    private static IRangeAdaptor getRangeAdaptor(IOpenClass methodType, IOpenClass paramType) {
        if (ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Number.class, (boolean)true)) {
            if (IntRange.class.equals((Object)paramType.getInstanceClass())) {
                return new IntRangeAdaptor();
            }
            if (DoubleRange.class.equals((Object)paramType.getInstanceClass())) {
                return new DoubleRangeAdaptor();
            }
        }
        return null;
    }

    public static IConditionEvaluator makeEvaluator(ICondition condition, IOpenClass methodType) throws SyntaxNodeException {
        IParameterDeclaration[] params = condition.getParams();
        switch (params.length) {
            case 1: {
                IOpenClass paramType = params[0].getType();
                if (methodType.equals(paramType) || methodType.getInstanceClass().equals(paramType.getInstanceClass())) {
                    return new EqualsIndexedEvaluator();
                }
                IAggregateInfo aggregateInfo = paramType.getAggregateInfo();
                if (aggregateInfo.isAggregate(paramType) && aggregateInfo.getComponentType(paramType).equals(methodType)) {
                    return new ContainsInArrayIndexedEvaluator();
                }
                IRangeAdaptor rangeAdaptor = DecisionTableOptimizedAlgorithm.getRangeAdaptor(methodType, paramType);
                if (rangeAdaptor != null) {
                    return new RangeIndexedEvaluator(rangeAdaptor);
                }
                if (!JavaOpenClass.BOOLEAN.equals((Object)methodType)) break;
                return new DefaultConditionEvaluator();
            }
            case 2: {
                BooleanTypeAdaptor booleanTypeAdaptor;
                IOpenClass paramType0 = params[0].getType();
                IOpenClass paramType1 = params[1].getType();
                if (methodType == paramType0 && methodType == paramType1) {
                    Class clazz = methodType.getInstanceClass();
                    if (clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Double.TYPE && clazz != Float.TYPE && !Comparable.class.isAssignableFrom(clazz)) {
                        String message = String.format("Type '%s' is not Comparable", methodType.getName());
                        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getSourceCodeModule());
                    }
                    return new RangeIndexedEvaluator(null);
                }
                IAggregateInfo aggregateInfo = paramType1.getAggregateInfo();
                if (!aggregateInfo.isAggregate(paramType1) || aggregateInfo.getComponentType(paramType1) != methodType || (booleanTypeAdaptor = BooleanAdaptorFactory.getAdaptor(paramType0)) == null) break;
                return new ContainsInOrNotInArrayIndexedEvaluator(booleanTypeAdaptor);
            }
        }
        ArrayList<String> names = new ArrayList<String>();
        for (IParameterDeclaration parameterDeclaration : params) {
            String name = parameterDeclaration.getType().getName();
            names.add(name);
        }
        String parametersString = StringUtils.join(names, (String)",");
        String message = String.format("Can not make a Condition Evaluator for parameter %s and [%s]", methodType.getName(), parametersString);
        throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)condition.getSourceCodeModule());
    }

    public void buildIndex() throws Exception {
        ArrayList<Object[][]> params = new ArrayList<Object[][]>();
        for (int i = 0; i < this.evaluators.length && this.evaluators[i].isIndexed(); ++i) {
            Object[][] values = this.table.getConditionRows()[i].getParamValues();
            Object[][] precalculatedParams = this.prepareIndexedParams(values);
            params.add(precalculatedParams);
            if (this.isDependecyOnConditionExists(this.table.getConditionRows()[i])) continue;
            this.table.getConditionRows()[i].clearParamValues();
        }
        this.dependencies = null;
        if (params.size() == 0) {
            return;
        }
        Object[][] params0 = (Object[][])params.get(0);
        this.indexRoot = this.evaluators[0].makeIndex(params0, new IntRangeDomain(0, params0.length - 1).intIterator());
        this.indexNodes(this.indexRoot, params, 1);
    }

    private boolean isDependecyOnConditionExists(ICondition condition) {
        for (IOpenField field : this.dependencies.getFieldsMap().values()) {
            if (!(field instanceof ConditionOrActionParameterField) || ((ConditionOrActionParameterField)field).getConditionOrAction() != condition) continue;
            return true;
        }
        return false;
    }

    public IIntIterator checkedRules(Object target, Object[] params, IRuntimeEnv env) {
        int conditionNumber;
        ICondition[] conditions = this.table.getConditionRows();
        IIntIterator iterator = null;
        if (this.indexRoot == null) {
            iterator = new IntRangeDomain(0, this.table.getNumberOfRules() - 1).intIterator();
        } else {
            ARuleIndex index = this.indexRoot;
            for (conditionNumber = 0; conditionNumber < this.evaluators.length; ++conditionNumber) {
                Object testValue = this.evaluateTestValue(conditions[conditionNumber], target, params, env);
                DecisionTableRuleNode node = index.findNode(testValue);
                if (!node.hasIndex()) {
                    iterator = node.getRulesIterator();
                    ++conditionNumber;
                    break;
                }
                index = node.getNextIndex();
            }
        }
        while (conditionNumber < this.evaluators.length) {
            ICondition condition = conditions[conditionNumber];
            IConditionEvaluator evaluator = this.evaluators[conditionNumber];
            IIntSelector sel = evaluator.getSelector(condition, target, params, env);
            iterator = iterator.select(sel);
            ++conditionNumber;
        }
        return iterator;
    }

    private void indexNode(DecisionTableRuleNode node, ArrayList<Object[][]> params, int level) {
        ARuleIndex nodeIndex = this.evaluators[level].makeIndex(params.get(level), node.getRulesIterator());
        node.setNextIndex(nodeIndex);
        this.indexNodes(nodeIndex, params, level + 1);
    }

    private void indexNodes(ARuleIndex index, ArrayList<Object[][]> params, int level) {
        if (index == null) {
            return;
        }
        if (params.size() <= level) {
            return;
        }
        Iterator<DecisionTableRuleNode> iter = index.nodes();
        while (iter.hasNext()) {
            DecisionTableRuleNode node = iter.next();
            this.indexNode(node, params, level);
        }
        this.indexNode(index.getEmptyOrFormulaNodes(), params, level);
    }

    private Object[][] prepareIndexedParams(Object[][] params) throws SyntaxNodeException {
        Object[][] indexedParams = new Object[params.length][];
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                indexedParams[i] = null;
                continue;
            }
            Object[] values = new Object[params[i].length];
            for (int j = 0; j < values.length; ++j) {
                Object value = params[i][j];
                if (value instanceof IOpenMethod) {
                    throw SyntaxNodeExceptionUtils.createError((String)"Can not index conditions with formulas", (ISyntaxNode)this.table.getSyntaxNode());
                }
                values[j] = value;
                indexedParams[i] = values;
            }
        }
        return indexedParams;
    }
}

