/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.RangeSelector;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.index.RangeIndex;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.util.IntervalMap;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIndexedEvaluator
implements IConditionEvaluator {
    private IRangeAdaptor<Object, Object> adaptor;

    public RangeIndexedEvaluator(IRangeAdaptor<Object, Object> adaptor) {
        this.adaptor = adaptor;
    }

    @Override
    public IOpenSourceCodeModule getFormalSourceCode(ICondition condition) {
        IOpenSourceCodeModule conditionSource = condition.getSourceCodeModule();
        String name = condition.getParams()[1].getName();
        String code = String.format("%1$s<=(%2$s) && (%2$s) < %1$s", name, conditionSource.getCode());
        return new StringSourceCodeModule(code, conditionSource.getUri(0));
    }

    @Override
    public IIntSelector getSelector(ICondition condition, Object target, Object[] dtparams, IRuntimeEnv env) {
        Object value = condition.getEvaluator().invoke(target, dtparams, env);
        return new RangeSelector(condition, value, target, dtparams, this.adaptor, env);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ARuleIndex makeIndex(Object[][] indexedparams, IIntIterator iterator) {
        if (iterator.size() < 1) {
            return null;
        }
        IntervalMap map = new IntervalMap();
        DecisionTableRuleNodeBuilder emptyBuilder = new DecisionTableRuleNodeBuilder();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (indexedparams[i] == null || indexedparams[i][0] == null) {
                emptyBuilder.addRule(i);
                continue;
            }
            Comparable<Object> vFrom = null;
            Comparable<Object> vTo = null;
            if (this.adaptor == null) {
                vFrom = (Comparable<Object>)indexedparams[i][0];
                vTo = (Comparable<Object>)indexedparams[i][1];
            } else {
                vFrom = this.adaptor.getMin(indexedparams[i][0]);
                vTo = this.adaptor.getMax(indexedparams[i][0]);
            }
            map.putInterval(vFrom, vTo, (Object)new Integer(i));
        }
        TreeMap treeMap = map.treeMap();
        ArrayList<Comparable> index = new ArrayList<Comparable>();
        ArrayList<DecisionTableRuleNode> rules = new ArrayList<DecisionTableRuleNode>();
        int i = 0;
        DecisionTableRuleNode emptyNode = emptyBuilder.makeNode("Empty");
        for (Map.Entry element : treeMap.entrySet()) {
            Comparable indexObj = (Comparable)element.getKey();
            List<Integer> list = (List<Integer>)element.getValue();
            if (emptyNode.getRules().length > 0) {
                list = this.merge(list, emptyNode.getRules());
            }
            int[] idxAry = new int[list.size()];
            for (int j = 0; j < idxAry.length; ++j) {
                idxAry[j] = list.get(j);
            }
            rules.add(new DecisionTableRuleNode(idxAry));
            index.add(indexObj);
            ++i;
        }
        return new RangeIndex(emptyNode, index.toArray(new Comparable[0]), rules.toArray(new DecisionTableRuleNode[0]));
    }

    private List<Integer> merge(List<Integer> list, int[] rules) {
        int idx1 = 0;
        int idx2 = 0;
        int N = list.size() + rules.length;
        ArrayList<Integer> newList = new ArrayList<Integer>(N);
        for (int i = 0; i < N; ++i) {
            int i2;
            if (idx1 == list.size()) {
                newList.add(rules[idx2++]);
                continue;
            }
            if (idx2 == rules.length) {
                newList.add(list.get(idx1++));
                continue;
            }
            int i1 = list.get(idx1);
            if (i1 < (i2 = rules[idx2])) {
                newList.add(i1);
                ++idx1;
                continue;
            }
            newList.add(i2);
            ++idx2;
        }
        return newList;
    }
}

