/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import org.openl.domain.IIntSelector;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeSelector
implements IIntSelector {
    private ICondition condition;
    private Object value;
    private Object target;
    private Object[] params;
    private IRuntimeEnv env;
    private IRangeAdaptor<Object, Object> adaptor;

    public RangeSelector(ICondition condition, Object value, Object target, Object[] params, IRangeAdaptor<Object, Object> adaptor, IRuntimeEnv env) {
        this.condition = condition;
        this.value = value;
        this.params = params;
        this.adaptor = adaptor;
        this.env = env;
        this.target = target;
    }

    public boolean select(int rule) {
        Object[][] params = this.condition.getParamValues();
        Object[] ruleParams = params[rule];
        if (ruleParams == null) {
            return true;
        }
        Object[] realParams = new Object[ruleParams.length];
        RuleRowHelper.loadParams(realParams, 0, ruleParams, this.target, this.params, this.env);
        Comparable<Object> vFrom = null;
        Comparable<Object> vTo = null;
        if (this.adaptor == null) {
            vFrom = (Comparable<Object>)realParams[0];
            vTo = (Comparable<Object>)realParams[1];
        } else {
            vFrom = this.adaptor.getMin(realParams[0]);
            vTo = this.adaptor.getMax(realParams[0]);
        }
        return vFrom.compareTo(this.value) <= 0 && ((Comparable)this.value).compareTo(vTo) < 0;
    }
}

