/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.vm.IRuntimeEnv;

public class Action
extends FunctionalRow
implements IAction {
    private boolean isReturnAction = false;
    private boolean isSingleReturnParam = false;
    private IOpenClass ruleExecutionType;

    public Action(String name, int row, ILogicalTable decisionTable, boolean isReturnAction) {
        super(name, row, decisionTable);
        this.isReturnAction = isReturnAction;
    }

    public boolean isAction() {
        return true;
    }

    public boolean isCondition() {
        return false;
    }

    public boolean isReturnAction() {
        return this.isReturnAction;
    }

    public Object executeAction(int column, Object target, Object[] params, IRuntimeEnv env) {
        if (this.isSingleReturnParam) {
            Object[] values = this.getParamValues()[column];
            if (values == null) {
                return null;
            }
            Object[] array = new Object[values.length];
            RuleRowHelper.loadParams(array, 0, values, target, params, env);
            Object returnValue = array[0];
            IOpenMethod method = this.getMethod();
            IOpenClass returnType = method.getType();
            if (returnValue == null || ClassUtils.isAssignable(returnValue.getClass(), (Class)returnType.getInstanceClass(), (boolean)true)) {
                return returnValue;
            }
            return this.executeActionInternal(column, target, params, env);
        }
        return this.executeActionInternal(column, target, params, env);
    }

    private Object executeActionInternal(int ruleNum, Object target, Object[] params, IRuntimeEnv env) {
        Object[][] values = this.getParamValues();
        if (values == null) {
            return null;
        }
        Object[] value = this.getParamValues()[ruleNum];
        if (value == null) {
            return null;
        }
        RuleExecutionObject newTarget = new RuleExecutionObject(this.ruleExecutionType, target, ruleNum);
        return this.getMethod().invoke((Object)newTarget, this.mergeParams(target, params, env, value), env);
    }

    public void prepareAction(IOpenClass methodType, IMethodSignature signature, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator, RuleRow ruleRow, IOpenClass ruleExecutionType) throws Exception {
        this.prepare(methodType, signature, openl, module, bindingContextDelegator, ruleRow);
        this.ruleExecutionType = ruleExecutionType;
        IParameterDeclaration[] params = this.getParams();
        CompositeMethod method = (CompositeMethod)this.getMethod();
        String code = method.getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        this.isSingleReturnParam = params.length == 1 && params[0].getName().equals(code);
    }

    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if ("extraRet".equals(methodSource.getCode()) && this.isReturnAction() && this.getParams() == null) {
            ParameterDeclaration extraParam = new ParameterDeclaration(methodType, "extraRet");
            IParameterDeclaration[] parameterDeclarations = new IParameterDeclaration[]{extraParam};
            this.setParams(parameterDeclarations);
            return this.getParams();
        }
        return super.getParams(methodSource, signature, declaringClass, methodType, openl, bindingContext);
    }

    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext) {
        IOpenSourceCodeModule source = super.getExpressionSource(bindingContext);
        if (this.isReturnAction() && StringUtils.isEmpty((String)source.getCode()) && this.getParams() == null) {
            return new StringSourceCodeModule("extraRet", source.getUri(0));
        }
        return super.getExpressionSource(bindingContext);
    }
}

