/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import org.apache.commons.lang.StringUtils;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.dt.algorithm.DecisionTableOptimizedAlgorithm;
import org.openl.rules.dt.algorithm.evaluator.DefaultConditionEvaluator;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.element.DecisionValue;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.types.impl.ParameterMethodCaller;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class Condition
extends FunctionalRow
implements ICondition {
    private IMethodCaller evaluator;
    private IConditionEvaluator conditionEvaluator;

    public Condition(String name, int row, ILogicalTable decisionTable) {
        super(name, row, decisionTable);
    }

    public IConditionEvaluator getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    public boolean isAction() {
        return false;
    }

    public boolean isCondition() {
        return true;
    }

    public IMethodCaller getEvaluator() {
        return this.evaluator == null ? this.getMethod() : this.evaluator;
    }

    public IConditionEvaluator prepareCondition(IMethodSignature signature, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator, RuleRow ruleRow) throws Exception {
        IConditionEvaluator dtcev;
        super.prepare((IOpenClass)NullOpenClass.the, signature, openl, module, bindingContextDelegator, ruleRow);
        IOpenSourceCodeModule source = ((CompositeMethod)this.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule();
        if (StringUtils.isEmpty((String)source.getCode())) {
            throw SyntaxNodeExceptionUtils.createError((String)"Cannot execute empty expression", (IOpenSourceCodeModule)source);
        }
        IOpenClass methodType = ((CompositeMethod)this.getMethod()).getBodyType();
        if (this.isDependentOnAnyParams()) {
            if (methodType != JavaOpenClass.BOOLEAN && methodType != JavaOpenClass.getOpenClass(Boolean.class)) {
                throw new Exception("Condition must have boolean type if it depends on it's parameters");
            }
            this.conditionEvaluator = new DefaultConditionEvaluator();
            return this.conditionEvaluator;
        }
        this.evaluator = this.makeOptimizedConditionMethodEvaluator(signature);
        this.conditionEvaluator = dtcev = DecisionTableOptimizedAlgorithm.makeEvaluator(this, methodType);
        return this.conditionEvaluator;
    }

    public DecisionValue calculateCondition(int rule, Object target, Object[] dtParams, IRuntimeEnv env) {
        Object[] value = this.getParamValues()[rule];
        if (value == null) {
            return DecisionValue.NxA_VALUE;
        }
        if (value instanceof DecisionValue) {
            return (DecisionValue)value;
        }
        Object[] params = this.mergeParams(target, dtParams, env, value);
        Boolean res = (Boolean)this.getMethod().invoke(target, params, env);
        if (res == null || res.booleanValue()) {
            return DecisionValue.TRUE_VALUE;
        }
        return DecisionValue.FALSE_VALUE;
    }

    private IOpenField getLocalField(IOpenField f) {
        if (f instanceof ILocalVar) {
            return f;
        }
        if (f instanceof OpenFieldDelegator) {
            OpenFieldDelegator d = (OpenFieldDelegator)f;
            return d.getField();
        }
        return f;
    }

    private boolean isDependentOnAnyParams() {
        IParameterDeclaration[] params = this.getParams();
        BindingDependencies dependencies = new BindingDependencies();
        ((CompositeMethod)this.getMethod()).updateDependency(dependencies);
        for (IOpenField field : dependencies.getFieldsMap().values()) {
            if (!((field = this.getLocalField(field)) instanceof ILocalVar)) continue;
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getName().equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private IMethodCaller makeOptimizedConditionMethodEvaluator(IMethodSignature signature) {
        String code = ((CompositeMethod)this.getMethod()).getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            String pname = signature.getParameterName(i);
            if (!pname.equals(code)) continue;
            return new ParameterMethodCaller(this.getMethod(), i);
        }
        return null;
    }
}

