/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.ArrayList;
import java.util.HashSet;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.dt.element.DecisionTableParameterInfo;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.util.ArrayTool;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionalRow
implements IDecisionRow {
    private static final String NO_PARAM = "P";
    private String name;
    private int row;
    private CompositeMethod method;
    private IParameterDeclaration[] params;
    private Object[][] paramValues;
    private ILogicalTable decisionTable;
    private ILogicalTable paramsTable;
    private ILogicalTable codeTable;
    private ILogicalTable presentationTable;
    private int noParamsIndex = 0;

    public FunctionalRow(String name, int row, ILogicalTable decisionTable) {
        this.name = name;
        this.row = row;
        this.decisionTable = decisionTable;
        this.paramsTable = (ILogicalTable)decisionTable.getSubtable(2, row, 1, 1);
        this.codeTable = (ILogicalTable)decisionTable.getSubtable(1, row, 1, 1);
        this.presentationTable = (ILogicalTable)decisionTable.getSubtable(3, row, 1, 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IOpenMethod getMethod() {
        return this.method;
    }

    @Override
    public IParameterDeclaration[] getParams() {
        return this.params;
    }

    protected void setParams(IParameterDeclaration[] params) {
        this.params = params;
    }

    @Override
    public Object[][] getParamValues() {
        return this.paramValues;
    }

    @Override
    public void clearParamValues() {
        this.paramValues = null;
    }

    @Override
    public DecisionTableParameterInfo getParameterInfo(int i) {
        return new DecisionTableParameterInfo(i, this);
    }

    @Override
    public IOpenSourceCodeModule getSourceCodeModule() {
        if (this.method != null) {
            return this.method.getMethodBodyBoundNode().getSyntaxNode().getModule();
        }
        return null;
    }

    @Override
    public int numberOfParams() {
        return this.params.length;
    }

    @Override
    public ILogicalTable getDecisionTable() {
        return this.decisionTable;
    }

    @Override
    public String[] getParamPresentation() {
        int length = this.paramsTable.getHeight();
        String[] result = new String[length];
        int fromHeight = 0;
        for (int i = 0; i < result.length; ++i) {
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(i)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)this.presentationTable.getSource().getRows(fromHeight, fromHeight + gridHeight - 1);
            result[i] = singleParamGridTable.getCell(0, 0).getStringValue();
            fromHeight += gridHeight;
        }
        return result;
    }

    @Override
    public void prepare(IOpenClass methodType, IMethodSignature signature, OpenL openl, ModuleOpenClass module, IBindingContextDelegator bindingContextDelegator, RuleRow ruleRow) throws Exception {
        this.method = this.generateMethod(signature, openl, bindingContextDelegator, (IOpenClass)module, methodType);
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, (IBindingContext)bindingContextDelegator);
        OpenMethodHeader header = new OpenMethodHeader(this.name, null, signature, (IOpenClass)module);
        openlAdaptor.setHeader((IOpenMethodHeader)header);
        this.paramValues = this.prepareParamValues(this.method, openlAdaptor, ruleRow);
        if (bindingContextDelegator.isExecutionMode()) {
            this.decisionTable = null;
            this.paramsTable = null;
            this.codeTable = null;
            this.presentationTable = null;
        }
    }

    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (this.params == null) {
            HashSet<String> paramNames = new HashSet<String>();
            int length = this.paramsTable.getHeight();
            this.params = new IParameterDeclaration[length];
            for (int i = 0; i < length; ++i) {
                ILogicalTable paramTable = (ILogicalTable)this.paramsTable.getRow(i);
                GridCellSourceCodeModule source = new GridCellSourceCodeModule(paramTable.getSource(), bindingContext);
                IParameterDeclaration parameterDeclaration = this.getParameterDeclaration(source, methodSource, signature, declaringClass, methodType, openl, bindingContext);
                String paramName = parameterDeclaration.getName();
                if (paramNames.contains(paramName)) {
                    throw SyntaxNodeExceptionUtils.createError((String)("Duplicated parameter name: " + paramName), (IOpenSourceCodeModule)source);
                }
                paramNames.add(paramName);
                this.params[i] = parameterDeclaration;
            }
        }
        return this.params;
    }

    private Object[][] prepareParamValues(CompositeMethod method, OpenlToolAdaptor ota, RuleRow ruleRow) throws Exception {
        int len = this.nValues();
        IParameterDeclaration[] paramDecl = this.getParams(method.getMethodBodyBoundNode().getSyntaxNode().getModule(), method.getSignature(), method.getDeclaringClass(), method.getType(), ota.getOpenl(), ota.getBindingContext());
        boolean[] paramIndexed = this.getParamIndexed(paramDecl);
        ArrayList<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
        Object[][] preparedValues = new Object[len][];
        for (int columnNumber = 0; columnNumber < len; ++columnNumber) {
            Object[] loadedColumnParams = this.loadParamsFromColumn(ota, ruleRow, paramDecl, paramIndexed, errors, columnNumber);
            if (ArrayTool.isEmpty((Object[])loadedColumnParams)) continue;
            preparedValues[columnNumber] = loadedColumnParams;
        }
        if (errors.size() > 0) {
            throw new CompositeSyntaxNodeException("Error:", errors.toArray(new SyntaxNodeException[0]));
        }
        return preparedValues;
    }

    private Object[] loadParamsFromColumn(OpenlToolAdaptor ota, RuleRow ruleRow, IParameterDeclaration[] paramDecl, boolean[] paramIndexed, ArrayList<SyntaxNodeException> errors, int columnNumber) {
        IGridTable paramGridColumn = this.getValueCell(columnNumber).getSource();
        int fromHeight = 0;
        String ruleName = ruleRow == null ? "R" + (columnNumber + 1) : ruleRow.getRuleName(columnNumber);
        Object[] valueAry = new Object[paramDecl.length];
        for (int j = 0; j < paramDecl.length; ++j) {
            if (paramDecl[j] == null) continue;
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(j)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)paramGridColumn.getRows(fromHeight, fromHeight + gridHeight - 1);
            Object loadedValue = null;
            try {
                IOpenClass paramType = paramDecl[j].getType();
                loadedValue = RuleRowHelper.loadParam(LogicalTableHelper.logicalTable(singleParamGridTable), paramType, paramDecl[j].getName(), ruleName, ota, paramIndexed[j]);
            }
            catch (SyntaxNodeException error) {
                errors.add(error);
            }
            valueAry[j] = loadedValue;
            fromHeight += gridHeight;
        }
        return valueAry;
    }

    private boolean[] getParamIndexed(IParameterDeclaration[] paramDecl) {
        boolean[] paramIndexed = new boolean[paramDecl.length];
        for (int i = 0; i < paramIndexed.length; ++i) {
            paramIndexed[i] = paramDecl[i].getType().getAggregateInfo().isAggregate(paramDecl[i].getType());
        }
        return paramIndexed;
    }

    protected Object[] mergeParams(Object target, Object[] dtParams, IRuntimeEnv env, Object[] params) {
        if (dtParams == null) {
            dtParams = new Object[]{};
        }
        if (params == null) {
            params = new Object[]{};
        }
        Object[] newParams = new Object[dtParams.length + params.length];
        System.arraycopy(dtParams, 0, newParams, 0, dtParams.length);
        RuleRowHelper.loadParams(newParams, dtParams.length, params, target, dtParams, env);
        return newParams;
    }

    private ILogicalTable getValueCell(int column) {
        return (ILogicalTable)this.decisionTable.getSubtable(column + 4, this.row, 1, 1);
    }

    private int nValues() {
        return this.decisionTable.getWidth() - 4;
    }

    private String makeParamName() {
        ++this.noParamsIndex;
        return NO_PARAM + this.noParamsIndex;
    }

    private CompositeMethod generateMethod(IMethodSignature signature, OpenL openl, IBindingContextDelegator bindingContextDelegator, IOpenClass declaringClass, IOpenClass methodType) throws Exception {
        IOpenSourceCodeModule source = this.getExpressionSource((IBindingContext)bindingContextDelegator);
        IParameterDeclaration[] methodParams = this.getParams(source, signature, declaringClass, methodType, openl, (IBindingContext)bindingContextDelegator);
        MethodSignature newSignature = ((MethodSignature)signature).merge(methodParams);
        OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, (IMethodSignature)newSignature, declaringClass);
        return OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)source, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContextDelegator);
    }

    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext) {
        return new GridCellSourceCodeModule(this.codeTable.getSource(), bindingContext);
    }

    private IParameterDeclaration getParameterDeclaration(IOpenSourceCodeModule paramSource, IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws OpenLCompilationException {
        IdentifierNode[] nodes = Tokenizer.tokenize((IOpenSourceCodeModule)paramSource, (String)" \n\r");
        if (nodes.length == 0) {
            try {
                OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, signature, declaringClass);
                CompositeMethod method = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)methodSource, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContext);
                IOpenClass type = method.getBodyType();
                if (type instanceof NullOpenClass) {
                    String message = String.format("Cannot recognize type of local parameter for expression", new Object[0]);
                    throw SyntaxNodeExceptionUtils.createError((String)message, null, null, (IOpenSourceCodeModule)methodSource);
                }
                String paramName = this.makeParamName();
                return new ParameterDeclaration(type, paramName);
            }
            catch (Exception ex) {
                throw SyntaxNodeExceptionUtils.createError((String)"Cannot compile expression", (Throwable)ex, null, (IOpenSourceCodeModule)methodSource);
            }
        }
        if (nodes.length > 2) {
            String errMsg = "Parameter Cell format: <type> <name>";
            throw SyntaxNodeExceptionUtils.createError((String)errMsg, null, null, (IOpenSourceCodeModule)methodSource);
        }
        String typeCode = nodes[0].getIdentifier();
        IOpenClass type = RuleRowHelper.getType(typeCode, bindingContext);
        if (type == null) {
            throw SyntaxNodeExceptionUtils.createError((String)("Type not found: " + typeCode), (ISyntaxNode)nodes[0]);
        }
        if (nodes.length == 1) {
            String paramName = this.makeParamName();
            return new ParameterDeclaration(type, paramName);
        }
        String name = nodes[1].getIdentifier();
        return new ParameterDeclaration(type, name);
    }
}

