/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.helpers.NumberUtils;
import org.openl.util.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsIndex
extends ARuleIndex {
    private HashMap<Object, DecisionTableRuleNode> valueNodes = new HashMap();

    public EqualsIndex(DecisionTableRuleNode emptyOrFormulaNodes, HashMap<Object, DecisionTableRuleNode> valueNodes) {
        super(emptyOrFormulaNodes);
        this.valueNodes = valueNodes;
    }

    @Override
    public DecisionTableRuleNode findNodeInIndex(Object value) {
        if (value != null) {
            DecisionTableRuleNode result = this.valueNodes.get(value);
            if (result == null && NumberUtils.isFloatPointNumber(value)) {
                Set<Object> keys = this.valueNodes.keySet();
                Double objectValue = NumberUtils.convertToDouble(value);
                for (Object key : keys) {
                    if (!NumberUtils.isFloatPointNumber(value)) continue;
                    Double keyValue = NumberUtils.convertToDouble(key);
                    if (!MathUtils.eq((double)objectValue, (double)keyValue)) continue;
                    return this.valueNodes.get(key);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public Iterator<DecisionTableRuleNode> nodes() {
        return this.valueNodes.values().iterator();
    }
}

