/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.Arrays;
import java.util.Iterator;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.util.OpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIndex
extends ARuleIndex {
    private Comparable<?>[] index;
    private DecisionTableRuleNode[] rules;

    public RangeIndex(DecisionTableRuleNode emptyOrFormulaNodes, Comparable<Object>[] index, DecisionTableRuleNode[] rules) {
        super(emptyOrFormulaNodes);
        this.index = index;
        this.rules = rules;
    }

    @Override
    public DecisionTableRuleNode findNodeInIndex(Object value) {
        int idx = Arrays.binarySearch(this.index, this.convertValueForSearch(value));
        if (idx >= 0) {
            return this.rules[idx];
        }
        int insertionPoint = -(idx + 1);
        if (insertionPoint < this.index.length && insertionPoint > 0) {
            return this.rules[insertionPoint - 1];
        }
        return null;
    }

    private Object convertValueForSearch(Object value) {
        if (this.index.length < 1) {
            return value;
        }
        if (value instanceof Number) {
            if (this.index[0] instanceof Long) {
                return ((Number)value).longValue();
            }
            if (this.index[0] instanceof Double) {
                return ((Number)value).doubleValue();
            }
        }
        return value;
    }

    @Override
    public Iterator<DecisionTableRuleNode> nodes() {
        return OpenIterator.fromArray((Object[])this.rules);
    }
}

